package org.cloudfoundry.uaa.identityproviders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the update identity provider
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateIdentityProviderRequest"})
public final class UpdateIdentityProviderRequest
    extends org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest {
  private final @Nullable Boolean active;
  private final IdentityProviderConfiguration configuration;
  private final String identityProviderId;
  private final String name;
  private final String originKey;
  private final Type type;
  private final Integer version;
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;

  private UpdateIdentityProviderRequest(UpdateIdentityProviderRequest.Builder builder) {
    this.active = builder.active;
    this.configuration = builder.configuration;
    this.identityProviderId = builder.identityProviderId;
    this.name = builder.name;
    this.originKey = builder.originKey;
    this.type = builder.type;
    this.version = builder.version;
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
  }

  /**
   * Whether the identity provider is active
   */
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The configuration of this identity provider according to its type.
   */
  @Override
  public IdentityProviderConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The identity provider id
   */
  @Override
  public String getIdentityProviderId() {
    return identityProviderId;
  }

  /**
   * Human-readable name for this provider
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * A unique identifier for the IDP. Cannot be updated.
   */
  @Override
  public String getOriginKey() {
    return originKey;
  }

  /**
   * The type of the identity provider. Cannot be updated.
   */
  @Override
  public Type getType() {
    return type;
  }

  /**
   * Version of the identity provider data. Clients can use this to protect against conflicting updates.
   */
  @Override
  public Integer getVersion() {
    return version;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code UpdateIdentityProviderRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateIdentityProviderRequest
        && equalTo((UpdateIdentityProviderRequest) another);
  }

  private boolean equalTo(UpdateIdentityProviderRequest another) {
    return Objects.equals(active, another.active)
        && configuration.equals(another.configuration)
        && identityProviderId.equals(another.identityProviderId)
        && name.equals(another.name)
        && originKey.equals(another.originKey)
        && type.equals(another.type)
        && version.equals(another.version)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code configuration}, {@code identityProviderId}, {@code name}, {@code originKey}, {@code type}, {@code version}, {@code identityZoneId}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + configuration.hashCode();
    h += (h << 5) + identityProviderId.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + originKey.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateIdentityProviderRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateIdentityProviderRequest{"
        + "active=" + active
        + ", configuration=" + configuration
        + ", identityProviderId=" + identityProviderId
        + ", name=" + name
        + ", originKey=" + originKey
        + ", type=" + type
        + ", version=" + version
        + ", identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateIdentityProviderRequest UpdateIdentityProviderRequest}.
   * @return A new UpdateIdentityProviderRequest builder
   */
  public static UpdateIdentityProviderRequest.Builder builder() {
    return new UpdateIdentityProviderRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateIdentityProviderRequest UpdateIdentityProviderRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CONFIGURATION = 0x1L;
    private static final long INIT_BIT_IDENTITY_PROVIDER_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_ORIGIN_KEY = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private static final long INIT_BIT_VERSION = 0x20L;
    private long initBits = 0x3fL;

    private Boolean active;
    private IdentityProviderConfiguration configuration;
    private String identityProviderId;
    private String name;
    private String originKey;
    private Type type;
    private Integer version;
    private String identityZoneId;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateIdentityProviderRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateIdentityProviderRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateIdentityProviderRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest) {
        org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest instance = (org.cloudfoundry.uaa.identityproviders._UpdateIdentityProviderRequest) object;
        configuration(instance.getConfiguration());
        originKey(instance.getOriginKey());
        name(instance.getName());
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        type(instance.getType());
        version(instance.getVersion());
        identityProviderId(instance.getIdentityProviderId());
      }
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(IdentityProviderConfiguration configuration) {
      this.configuration = Objects.requireNonNull(configuration, "configuration");
      initBits &= ~INIT_BIT_CONFIGURATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getIdentityProviderId() identityProviderId} attribute.
     * @param identityProviderId The value for identityProviderId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityProviderId(String identityProviderId) {
      this.identityProviderId = Objects.requireNonNull(identityProviderId, "identityProviderId");
      initBits &= ~INIT_BIT_IDENTITY_PROVIDER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getOriginKey() originKey} attribute.
     * @param originKey The value for originKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder originKey(String originKey) {
      this.originKey = Objects.requireNonNull(originKey, "originKey");
      initBits &= ~INIT_BIT_ORIGIN_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(Integer version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIdentityProviderRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link UpdateIdentityProviderRequest UpdateIdentityProviderRequest}.
     * @return An immutable instance of UpdateIdentityProviderRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateIdentityProviderRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateIdentityProviderRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CONFIGURATION) != 0) attributes.add("configuration");
      if ((initBits & INIT_BIT_IDENTITY_PROVIDER_ID) != 0) attributes.add("identityProviderId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORIGIN_KEY) != 0) attributes.add("originKey");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build UpdateIdentityProviderRequest, some of required attributes are not set " + attributes;
    }
  }
}
