/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.applications._ApplicationStatisticsRequest;

public final class ApplicationStatisticsRequest
extends _ApplicationStatisticsRequest {
    private final String applicationId;

    private ApplicationStatisticsRequest(Builder builder) {
        this.applicationId = builder.applicationId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationStatisticsRequest && this.equalTo((ApplicationStatisticsRequest)another);
    }

    private boolean equalTo(ApplicationStatisticsRequest another) {
        return this.applicationId.equals(another.applicationId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationStatisticsRequest{applicationId=" + this.applicationId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String applicationId;

        private Builder() {
        }

        public final Builder from(ApplicationStatisticsRequest instance) {
            return this.from((_ApplicationStatisticsRequest)instance);
        }

        final Builder from(_ApplicationStatisticsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ApplicationStatisticsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ApplicationStatisticsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build ApplicationStatisticsRequest, some of required attributes are not set " + attributes;
        }
    }
}

