/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.organizations._AssociateOrganizationBillingManagerRequest;

public final class AssociateOrganizationBillingManagerRequest
extends _AssociateOrganizationBillingManagerRequest {
    private final String billingManagerId;
    private final String organizationId;

    private AssociateOrganizationBillingManagerRequest(Builder builder) {
        this.billingManagerId = builder.billingManagerId;
        this.organizationId = builder.organizationId;
    }

    @Override
    public String getBillingManagerId() {
        return this.billingManagerId;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssociateOrganizationBillingManagerRequest && this.equalTo((AssociateOrganizationBillingManagerRequest)another);
    }

    private boolean equalTo(AssociateOrganizationBillingManagerRequest another) {
        return this.billingManagerId.equals(another.billingManagerId) && this.organizationId.equals(another.organizationId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.billingManagerId.hashCode();
        h += (h << 5) + this.organizationId.hashCode();
        return h;
    }

    public String toString() {
        return "AssociateOrganizationBillingManagerRequest{billingManagerId=" + this.billingManagerId + ", organizationId=" + this.organizationId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BILLING_MANAGER_ID = 1L;
        private static final long INIT_BIT_ORGANIZATION_ID = 2L;
        private long initBits = 3L;
        private String billingManagerId;
        private String organizationId;

        private Builder() {
        }

        public final Builder from(AssociateOrganizationBillingManagerRequest instance) {
            return this.from((_AssociateOrganizationBillingManagerRequest)instance);
        }

        final Builder from(_AssociateOrganizationBillingManagerRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.billingManagerId(instance.getBillingManagerId());
            this.organizationId(instance.getOrganizationId());
            return this;
        }

        public final Builder billingManagerId(String billingManagerId) {
            this.billingManagerId = Objects.requireNonNull(billingManagerId, "billingManagerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AssociateOrganizationBillingManagerRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AssociateOrganizationBillingManagerRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("billingManagerId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build AssociateOrganizationBillingManagerRequest, some of required attributes are not set " + attributes;
        }
    }
}

