/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicekeys;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.servicekeys._GetServiceKeyRequest;

public final class GetServiceKeyRequest
extends _GetServiceKeyRequest {
    private final String serviceKeyId;

    private GetServiceKeyRequest(Builder builder) {
        this.serviceKeyId = builder.serviceKeyId;
    }

    @Override
    public String getServiceKeyId() {
        return this.serviceKeyId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetServiceKeyRequest && this.equalTo((GetServiceKeyRequest)another);
    }

    private boolean equalTo(GetServiceKeyRequest another) {
        return this.serviceKeyId.equals(another.serviceKeyId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.serviceKeyId.hashCode();
        return h;
    }

    public String toString() {
        return "GetServiceKeyRequest{serviceKeyId=" + this.serviceKeyId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_KEY_ID = 1L;
        private long initBits = 1L;
        private String serviceKeyId;

        private Builder() {
        }

        public final Builder from(GetServiceKeyRequest instance) {
            return this.from((_GetServiceKeyRequest)instance);
        }

        final Builder from(_GetServiceKeyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.serviceKeyId(instance.getServiceKeyId());
            return this;
        }

        public final Builder serviceKeyId(String serviceKeyId) {
            this.serviceKeyId = Objects.requireNonNull(serviceKeyId, "serviceKeyId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public GetServiceKeyRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetServiceKeyRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceKeyId");
            }
            return "Cannot build GetServiceKeyRequest, some of required attributes are not set " + attributes;
        }
    }
}

