/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.userprovidedserviceinstances._ListUserProvidedServiceInstanceRoutesRequest;

public final class ListUserProvidedServiceInstanceRoutesRequest
extends _ListUserProvidedServiceInstanceRoutesRequest {
    @Nullable
    private final List<String> domainId;
    @Nullable
    private final List<String> host;
    @Nullable
    private final List<String> organizationId;
    @Nullable
    private final List<String> path;
    @Nullable
    private final List<String> port;
    private final String userProvidedServiceInstanceId;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListUserProvidedServiceInstanceRoutesRequest(Builder builder) {
        this.domainId = builder.domainId == null ? null : ListUserProvidedServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.domainId);
        this.host = builder.host == null ? null : ListUserProvidedServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.host);
        this.organizationId = builder.organizationId == null ? null : ListUserProvidedServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.organizationId);
        this.path = builder.path == null ? null : ListUserProvidedServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.path);
        this.port = builder.port == null ? null : ListUserProvidedServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.port);
        this.userProvidedServiceInstanceId = builder.userProvidedServiceInstanceId;
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getDomainId() {
        return this.domainId;
    }

    @Override
    @Nullable
    public List<String> getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public List<String> getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Nullable
    public List<String> getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public List<String> getPort() {
        return this.port;
    }

    @Override
    public String getUserProvidedServiceInstanceId() {
        return this.userProvidedServiceInstanceId;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListUserProvidedServiceInstanceRoutesRequest && this.equalTo((ListUserProvidedServiceInstanceRoutesRequest)another);
    }

    private boolean equalTo(ListUserProvidedServiceInstanceRoutesRequest another) {
        return Objects.equals(this.domainId, another.domainId) && Objects.equals(this.host, another.host) && Objects.equals(this.organizationId, another.organizationId) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port) && this.userProvidedServiceInstanceId.equals(another.userProvidedServiceInstanceId) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.domainId);
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.organizationId);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + this.userProvidedServiceInstanceId.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListUserProvidedServiceInstanceRoutesRequest{domainId=" + this.domainId + ", host=" + this.host + ", organizationId=" + this.organizationId + ", path=" + this.path + ", port=" + this.port + ", userProvidedServiceInstanceId=" + this.userProvidedServiceInstanceId + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_PROVIDED_SERVICE_INSTANCE_ID = 1L;
        private long initBits = 1L;
        private List<String> domainId = null;
        private List<String> host = null;
        private List<String> organizationId = null;
        private List<String> path = null;
        private List<String> port = null;
        private String userProvidedServiceInstanceId;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(ListUserProvidedServiceInstanceRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListUserProvidedServiceInstanceRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListUserProvidedServiceInstanceRoutesRequest) {
                List<String> domainIdValue;
                List<String> pathValue;
                List<String> hostValue;
                instance = (_ListUserProvidedServiceInstanceRoutesRequest)object;
                List<String> organizationIdValue = ((_ListUserProvidedServiceInstanceRoutesRequest)instance).getOrganizationId();
                if (organizationIdValue != null) {
                    this.addAllOrganizationId(organizationIdValue);
                }
                if ((hostValue = ((_ListUserProvidedServiceInstanceRoutesRequest)instance).getHost()) != null) {
                    this.addAllHost(hostValue);
                }
                if ((pathValue = ((_ListUserProvidedServiceInstanceRoutesRequest)instance).getPath()) != null) {
                    this.addAllPath(pathValue);
                }
                this.userProvidedServiceInstanceId(((_ListUserProvidedServiceInstanceRoutesRequest)instance).getUserProvidedServiceInstanceId());
                List<String> portValue = ((_ListUserProvidedServiceInstanceRoutesRequest)instance).getPort();
                if (portValue != null) {
                    this.addAllPort(portValue);
                }
                if ((domainIdValue = ((_ListUserProvidedServiceInstanceRoutesRequest)instance).getDomainId()) != null) {
                    this.addAllDomainId(domainIdValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder domainId(String element) {
            if (this.domainId == null) {
                this.domainId = new ArrayList<String>();
            }
            this.domainId.add(Objects.requireNonNull(element, "domainId element"));
            return this;
        }

        public final Builder domainId(String ... elements) {
            if (this.domainId == null) {
                this.domainId = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainId.add(Objects.requireNonNull(element, "domainId element"));
            }
            return this;
        }

        public final Builder domainId(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.domainId = null;
                return this;
            }
            this.domainId = new ArrayList<String>();
            return this.addAllDomainId(elements);
        }

        public final Builder addAllDomainId(Iterable<String> elements) {
            Objects.requireNonNull(elements, "domainId element");
            if (this.domainId == null) {
                this.domainId = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainId.add(Objects.requireNonNull(element, "domainId element"));
            }
            return this;
        }

        public final Builder host(String element) {
            if (this.host == null) {
                this.host = new ArrayList<String>();
            }
            this.host.add(Objects.requireNonNull(element, "host element"));
            return this;
        }

        public final Builder host(String ... elements) {
            if (this.host == null) {
                this.host = new ArrayList<String>();
            }
            for (String element : elements) {
                this.host.add(Objects.requireNonNull(element, "host element"));
            }
            return this;
        }

        public final Builder host(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.host = null;
                return this;
            }
            this.host = new ArrayList<String>();
            return this.addAllHost(elements);
        }

        public final Builder addAllHost(Iterable<String> elements) {
            Objects.requireNonNull(elements, "host element");
            if (this.host == null) {
                this.host = new ArrayList<String>();
            }
            for (String element : elements) {
                this.host.add(Objects.requireNonNull(element, "host element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationId == null) {
                this.organizationId = new ArrayList<String>();
            }
            this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
            return this;
        }

        public final Builder organizationId(String ... elements) {
            if (this.organizationId == null) {
                this.organizationId = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
            }
            return this;
        }

        public final Builder organizationId(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationId = null;
                return this;
            }
            this.organizationId = new ArrayList<String>();
            return this.addAllOrganizationId(elements);
        }

        public final Builder addAllOrganizationId(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationId element");
            if (this.organizationId == null) {
                this.organizationId = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
            }
            return this;
        }

        public final Builder path(String element) {
            if (this.path == null) {
                this.path = new ArrayList<String>();
            }
            this.path.add(Objects.requireNonNull(element, "path element"));
            return this;
        }

        public final Builder path(String ... elements) {
            if (this.path == null) {
                this.path = new ArrayList<String>();
            }
            for (String element : elements) {
                this.path.add(Objects.requireNonNull(element, "path element"));
            }
            return this;
        }

        public final Builder path(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.path = null;
                return this;
            }
            this.path = new ArrayList<String>();
            return this.addAllPath(elements);
        }

        public final Builder addAllPath(Iterable<String> elements) {
            Objects.requireNonNull(elements, "path element");
            if (this.path == null) {
                this.path = new ArrayList<String>();
            }
            for (String element : elements) {
                this.path.add(Objects.requireNonNull(element, "path element"));
            }
            return this;
        }

        public final Builder port(String element) {
            if (this.port == null) {
                this.port = new ArrayList<String>();
            }
            this.port.add(Objects.requireNonNull(element, "port element"));
            return this;
        }

        public final Builder port(String ... elements) {
            if (this.port == null) {
                this.port = new ArrayList<String>();
            }
            for (String element : elements) {
                this.port.add(Objects.requireNonNull(element, "port element"));
            }
            return this;
        }

        public final Builder port(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.port = null;
                return this;
            }
            this.port = new ArrayList<String>();
            return this.addAllPort(elements);
        }

        public final Builder addAllPort(Iterable<String> elements) {
            Objects.requireNonNull(elements, "port element");
            if (this.port == null) {
                this.port = new ArrayList<String>();
            }
            for (String element : elements) {
                this.port.add(Objects.requireNonNull(element, "port element"));
            }
            return this;
        }

        public final Builder userProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
            this.userProvidedServiceInstanceId = Objects.requireNonNull(userProvidedServiceInstanceId, "userProvidedServiceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListUserProvidedServiceInstanceRoutesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListUserProvidedServiceInstanceRoutesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userProvidedServiceInstanceId");
            }
            return "Cannot build ListUserProvidedServiceInstanceRoutesRequest, some of required attributes are not set " + attributes;
        }
    }
}

