/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitionResource;
import org.cloudfoundry.client.v2.users.UserResource;
import org.cloudfoundry.client.v2.users.UserSpaceResource;
import org.cloudfoundry.client.v2.users._UserOrganizationEntity;

public final class UserOrganizationEntity
extends _UserOrganizationEntity {
    @Nullable
    private final Boolean billingEnabled;
    @Nullable
    private final List<UserResource> managers;
    @Nullable
    private final String name;
    @Nullable
    private final String quotaDefinitionId;
    @Nullable
    private final List<OrganizationQuotaDefinitionResource> quotaDefinitions;
    @Nullable
    private final List<UserSpaceResource> spaces;
    @Nullable
    private final String status;

    private UserOrganizationEntity(Builder builder) {
        this.billingEnabled = builder.billingEnabled;
        this.managers = builder.managers == null ? null : UserOrganizationEntity.createUnmodifiableList(true, builder.managers);
        this.name = builder.name;
        this.quotaDefinitionId = builder.quotaDefinitionId;
        this.quotaDefinitions = builder.quotaDefinitions == null ? null : UserOrganizationEntity.createUnmodifiableList(true, builder.quotaDefinitions);
        this.spaces = builder.spaces == null ? null : UserOrganizationEntity.createUnmodifiableList(true, builder.spaces);
        this.status = builder.status;
    }

    @Override
    @JsonProperty(value="billing_enabled")
    @Nullable
    public Boolean getBillingEnabled() {
        return this.billingEnabled;
    }

    @Override
    @JsonProperty(value="managers")
    @Nullable
    public List<UserResource> getManagers() {
        return this.managers;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="quota_definition_guid")
    @Nullable
    public String getQuotaDefinitionId() {
        return this.quotaDefinitionId;
    }

    @Override
    @JsonProperty(value="quota_definition")
    @Nullable
    public List<OrganizationQuotaDefinitionResource> getQuotaDefinitions() {
        return this.quotaDefinitions;
    }

    @Override
    @JsonProperty(value="spaces")
    @Nullable
    public List<UserSpaceResource> getSpaces() {
        return this.spaces;
    }

    @Override
    @JsonProperty(value="status")
    @Nullable
    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserOrganizationEntity && this.equalTo((UserOrganizationEntity)another);
    }

    private boolean equalTo(UserOrganizationEntity another) {
        return Objects.equals(this.billingEnabled, another.billingEnabled) && Objects.equals(this.managers, another.managers) && Objects.equals(this.name, another.name) && Objects.equals(this.quotaDefinitionId, another.quotaDefinitionId) && Objects.equals(this.quotaDefinitions, another.quotaDefinitions) && Objects.equals(this.spaces, another.spaces) && Objects.equals(this.status, another.status);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.billingEnabled);
        h += (h << 5) + Objects.hashCode(this.managers);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.quotaDefinitionId);
        h += (h << 5) + Objects.hashCode(this.quotaDefinitions);
        h += (h << 5) + Objects.hashCode(this.spaces);
        h += (h << 5) + Objects.hashCode(this.status);
        return h;
    }

    public String toString() {
        return "UserOrganizationEntity{billingEnabled=" + this.billingEnabled + ", managers=" + this.managers + ", name=" + this.name + ", quotaDefinitionId=" + this.quotaDefinitionId + ", quotaDefinitions=" + this.quotaDefinitions + ", spaces=" + this.spaces + ", status=" + this.status + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UserOrganizationEntity fromJson(Json json) {
        Builder builder = UserOrganizationEntity.builder();
        if (json.billingEnabled != null) {
            builder.billingEnabled(json.billingEnabled);
        }
        if (json.managers != null) {
            builder.addAllManagers(json.managers);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.quotaDefinitionId != null) {
            builder.quotaDefinitionId(json.quotaDefinitionId);
        }
        if (json.quotaDefinitions != null) {
            builder.addAllQuotaDefinitions(json.quotaDefinitions);
        }
        if (json.spaces != null) {
            builder.addAllSpaces(json.spaces);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Boolean billingEnabled;
        private List<UserResource> managers = null;
        private String name;
        private String quotaDefinitionId;
        private List<OrganizationQuotaDefinitionResource> quotaDefinitions = null;
        private List<UserSpaceResource> spaces = null;
        private String status;

        private Builder() {
        }

        public final Builder from(UserOrganizationEntity instance) {
            return this.from((_UserOrganizationEntity)instance);
        }

        final Builder from(_UserOrganizationEntity instance) {
            String statusValue;
            List<UserSpaceResource> spacesValue;
            List<OrganizationQuotaDefinitionResource> quotaDefinitionsValue;
            String quotaDefinitionIdValue;
            String nameValue;
            List<UserResource> managersValue;
            Objects.requireNonNull(instance, "instance");
            Boolean billingEnabledValue = instance.getBillingEnabled();
            if (billingEnabledValue != null) {
                this.billingEnabled(billingEnabledValue);
            }
            if ((managersValue = instance.getManagers()) != null) {
                this.addAllManagers(managersValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((quotaDefinitionIdValue = instance.getQuotaDefinitionId()) != null) {
                this.quotaDefinitionId(quotaDefinitionIdValue);
            }
            if ((quotaDefinitionsValue = instance.getQuotaDefinitions()) != null) {
                this.addAllQuotaDefinitions(quotaDefinitionsValue);
            }
            if ((spacesValue = instance.getSpaces()) != null) {
                this.addAllSpaces(spacesValue);
            }
            if ((statusValue = instance.getStatus()) != null) {
                this.status(statusValue);
            }
            return this;
        }

        @JsonProperty(value="billing_enabled")
        public final Builder billingEnabled(@Nullable Boolean billingEnabled) {
            this.billingEnabled = billingEnabled;
            return this;
        }

        public final Builder manager(UserResource element) {
            if (this.managers == null) {
                this.managers = new ArrayList<UserResource>();
            }
            this.managers.add(Objects.requireNonNull(element, "managers element"));
            return this;
        }

        public final Builder manager(UserResource ... elements) {
            if (this.managers == null) {
                this.managers = new ArrayList<UserResource>();
            }
            for (UserResource element : elements) {
                this.managers.add(Objects.requireNonNull(element, "managers element"));
            }
            return this;
        }

        @JsonProperty(value="managers")
        public final Builder managers(@Nullable Iterable<? extends UserResource> elements) {
            if (elements == null) {
                this.managers = null;
                return this;
            }
            this.managers = new ArrayList<UserResource>();
            return this.addAllManagers(elements);
        }

        public final Builder addAllManagers(Iterable<? extends UserResource> elements) {
            Objects.requireNonNull(elements, "managers element");
            if (this.managers == null) {
                this.managers = new ArrayList<UserResource>();
            }
            for (UserResource userResource : elements) {
                this.managers.add(Objects.requireNonNull(userResource, "managers element"));
            }
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="quota_definition_guid")
        public final Builder quotaDefinitionId(@Nullable String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
            return this;
        }

        public final Builder quotaDefinition(OrganizationQuotaDefinitionResource element) {
            if (this.quotaDefinitions == null) {
                this.quotaDefinitions = new ArrayList<OrganizationQuotaDefinitionResource>();
            }
            this.quotaDefinitions.add(Objects.requireNonNull(element, "quotaDefinitions element"));
            return this;
        }

        public final Builder quotaDefinition(OrganizationQuotaDefinitionResource ... elements) {
            if (this.quotaDefinitions == null) {
                this.quotaDefinitions = new ArrayList<OrganizationQuotaDefinitionResource>();
            }
            for (OrganizationQuotaDefinitionResource element : elements) {
                this.quotaDefinitions.add(Objects.requireNonNull(element, "quotaDefinitions element"));
            }
            return this;
        }

        @JsonProperty(value="quota_definition")
        public final Builder quotaDefinitions(@Nullable Iterable<? extends OrganizationQuotaDefinitionResource> elements) {
            if (elements == null) {
                this.quotaDefinitions = null;
                return this;
            }
            this.quotaDefinitions = new ArrayList<OrganizationQuotaDefinitionResource>();
            return this.addAllQuotaDefinitions(elements);
        }

        public final Builder addAllQuotaDefinitions(Iterable<? extends OrganizationQuotaDefinitionResource> elements) {
            Objects.requireNonNull(elements, "quotaDefinitions element");
            if (this.quotaDefinitions == null) {
                this.quotaDefinitions = new ArrayList<OrganizationQuotaDefinitionResource>();
            }
            for (OrganizationQuotaDefinitionResource organizationQuotaDefinitionResource : elements) {
                this.quotaDefinitions.add(Objects.requireNonNull(organizationQuotaDefinitionResource, "quotaDefinitions element"));
            }
            return this;
        }

        public final Builder space(UserSpaceResource element) {
            if (this.spaces == null) {
                this.spaces = new ArrayList<UserSpaceResource>();
            }
            this.spaces.add(Objects.requireNonNull(element, "spaces element"));
            return this;
        }

        public final Builder space(UserSpaceResource ... elements) {
            if (this.spaces == null) {
                this.spaces = new ArrayList<UserSpaceResource>();
            }
            for (UserSpaceResource element : elements) {
                this.spaces.add(Objects.requireNonNull(element, "spaces element"));
            }
            return this;
        }

        @JsonProperty(value="spaces")
        public final Builder spaces(@Nullable Iterable<? extends UserSpaceResource> elements) {
            if (elements == null) {
                this.spaces = null;
                return this;
            }
            this.spaces = new ArrayList<UserSpaceResource>();
            return this.addAllSpaces(elements);
        }

        public final Builder addAllSpaces(Iterable<? extends UserSpaceResource> elements) {
            Objects.requireNonNull(elements, "spaces element");
            if (this.spaces == null) {
                this.spaces = new ArrayList<UserSpaceResource>();
            }
            for (UserSpaceResource userSpaceResource : elements) {
                this.spaces.add(Objects.requireNonNull(userSpaceResource, "spaces element"));
            }
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public UserOrganizationEntity build() {
            return new UserOrganizationEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _UserOrganizationEntity {
        Boolean billingEnabled;
        List<UserResource> managers = null;
        String name;
        String quotaDefinitionId;
        List<OrganizationQuotaDefinitionResource> quotaDefinitions = null;
        List<UserSpaceResource> spaces = null;
        String status;

        Json() {
        }

        @JsonProperty(value="billing_enabled")
        public void setBillingEnabled(@Nullable Boolean billingEnabled) {
            this.billingEnabled = billingEnabled;
        }

        @JsonProperty(value="managers")
        public void setManagers(@Nullable List<UserResource> managers) {
            this.managers = managers;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="quota_definition_guid")
        public void setQuotaDefinitionId(@Nullable String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
        }

        @JsonProperty(value="quota_definition")
        public void setQuotaDefinitions(@Nullable List<OrganizationQuotaDefinitionResource> quotaDefinitions) {
            this.quotaDefinitions = quotaDefinitions;
        }

        @JsonProperty(value="spaces")
        public void setSpaces(@Nullable List<UserSpaceResource> spaces) {
            this.spaces = spaces;
        }

        @JsonProperty(value="status")
        public void setStatus(@Nullable String status) {
            this.status = status;
        }

        @Override
        public Boolean getBillingEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserResource> getManagers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getQuotaDefinitionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OrganizationQuotaDefinitionResource> getQuotaDefinitions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserSpaceResource> getSpaces() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatus() {
            throw new UnsupportedOperationException();
        }
    }
}

