/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.applications._GetApplicationProcessRequest;

public final class GetApplicationProcessRequest
extends _GetApplicationProcessRequest {
    private final String applicationId;
    private final String type;

    private GetApplicationProcessRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.type = builder.type;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetApplicationProcessRequest && this.equalTo((GetApplicationProcessRequest)another);
    }

    private boolean equalTo(GetApplicationProcessRequest another) {
        return this.applicationId.equals(another.applicationId) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "GetApplicationProcessRequest{applicationId=" + this.applicationId + ", type=" + this.type + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private String applicationId;
        private String type;

        private Builder() {
        }

        public final Builder from(GetApplicationProcessRequest instance) {
            return this.from((_GetApplicationProcessRequest)instance);
        }

        final Builder from(_GetApplicationProcessRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.type(instance.getType());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public GetApplicationProcessRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetApplicationProcessRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build GetApplicationProcessRequest, some of required attributes are not set " + attributes;
        }
    }
}

