/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Checksum;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.droplets.Buildpack;
import org.cloudfoundry.client.v3.droplets.Droplet;
import org.cloudfoundry.client.v3.droplets.DropletState;
import org.cloudfoundry.client.v3.droplets._GetDropletResponse;

public final class GetDropletResponse
extends _GetDropletResponse {
    @Nullable
    private final List<Buildpack> buildpacks;
    @Nullable
    private final Checksum checksum;
    @Nullable
    private final String error;
    private final String executionMetadata;
    @Nullable
    private final String image;
    private final Lifecycle lifecycle;
    @Nullable
    private final Map<String, String> processTypes;
    @Nullable
    private final String stack;
    private final DropletState state;
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    private final String updatedAt;

    private GetDropletResponse(Builder builder) {
        this.buildpacks = builder.buildpacks == null ? null : GetDropletResponse.createUnmodifiableList(true, builder.buildpacks);
        this.checksum = builder.checksum;
        this.error = builder.error;
        this.executionMetadata = builder.executionMetadata;
        this.image = builder.image;
        this.lifecycle = builder.lifecycle;
        this.processTypes = builder.processTypes == null ? null : GetDropletResponse.createUnmodifiableMap(false, false, builder.processTypes);
        this.stack = builder.stack;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = GetDropletResponse.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
    }

    @Override
    @JsonProperty(value="buildpacks")
    @Nullable
    public List<Buildpack> getBuildpacks() {
        return this.buildpacks;
    }

    @Override
    @JsonProperty(value="checksum")
    @Nullable
    public Checksum getChecksum() {
        return this.checksum;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="execution_metadata")
    public String getExecutionMetadata() {
        return this.executionMetadata;
    }

    @Override
    @JsonProperty(value="image")
    @Nullable
    public String getImage() {
        return this.image;
    }

    @Override
    @JsonProperty(value="lifecycle")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @JsonProperty(value="process_types")
    @Nullable
    public Map<String, String> getProcessTypes() {
        return this.processTypes;
    }

    @Override
    @JsonProperty(value="stack")
    @Nullable
    public String getStack() {
        return this.stack;
    }

    @Override
    @JsonProperty(value="state")
    public DropletState getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetDropletResponse && this.equalTo((GetDropletResponse)another);
    }

    private boolean equalTo(GetDropletResponse another) {
        return Objects.equals(this.buildpacks, another.buildpacks) && Objects.equals(this.checksum, another.checksum) && Objects.equals(this.error, another.error) && this.executionMetadata.equals(another.executionMetadata) && Objects.equals(this.image, another.image) && this.lifecycle.equals(another.lifecycle) && Objects.equals(this.processTypes, another.processTypes) && Objects.equals(this.stack, another.stack) && this.state.equals((Object)another.state) && this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && this.updatedAt.equals(another.updatedAt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.buildpacks);
        h += (h << 5) + Objects.hashCode(this.checksum);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.executionMetadata.hashCode();
        h += (h << 5) + Objects.hashCode(this.image);
        h += (h << 5) + this.lifecycle.hashCode();
        h += (h << 5) + Objects.hashCode(this.processTypes);
        h += (h << 5) + Objects.hashCode(this.stack);
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        return h;
    }

    public String toString() {
        return "GetDropletResponse{buildpacks=" + this.buildpacks + ", checksum=" + this.checksum + ", error=" + this.error + ", executionMetadata=" + this.executionMetadata + ", image=" + this.image + ", lifecycle=" + this.lifecycle + ", processTypes=" + this.processTypes + ", stack=" + this.stack + ", state=" + (Object)((Object)this.state) + ", createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetDropletResponse fromJson(Json json) {
        Builder builder = GetDropletResponse.builder();
        if (json.buildpacks != null) {
            builder.addAllBuildpacks(json.buildpacks);
        }
        if (json.checksum != null) {
            builder.checksum(json.checksum);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.executionMetadata != null) {
            builder.executionMetadata(json.executionMetadata);
        }
        if (json.image != null) {
            builder.image(json.image);
        }
        if (json.lifecycle != null) {
            builder.lifecycle(json.lifecycle);
        }
        if (json.processTypes != null) {
            builder.putAllProcessTypes(json.processTypes);
        }
        if (json.stack != null) {
            builder.stack(json.stack);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_EXECUTION_METADATA = 1L;
        private static final long INIT_BIT_LIFECYCLE = 2L;
        private static final long INIT_BIT_STATE = 4L;
        private static final long INIT_BIT_CREATED_AT = 8L;
        private static final long INIT_BIT_ID = 16L;
        private static final long INIT_BIT_UPDATED_AT = 32L;
        private long initBits = 63L;
        private List<Buildpack> buildpacks = null;
        private Checksum checksum;
        private String error;
        private String executionMetadata;
        private String image;
        private Lifecycle lifecycle;
        private Map<String, String> processTypes = null;
        private String stack;
        private DropletState state;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;

        private Builder() {
        }

        public final Builder from(Droplet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetDropletResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetDropletResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof Droplet) {
                Map<String, String> processTypesValue;
                String stackValue;
                instance = (Droplet)object;
                List<Buildpack> buildpacksValue = ((Droplet)instance).getBuildpacks();
                if (buildpacksValue != null) {
                    this.addAllBuildpacks(buildpacksValue);
                }
                this.lifecycle(((Droplet)instance).getLifecycle());
                String imageValue = ((Droplet)instance).getImage();
                if (imageValue != null) {
                    this.image(imageValue);
                }
                if ((stackValue = ((Droplet)instance).getStack()) != null) {
                    this.stack(stackValue);
                }
                this.executionMetadata(((Droplet)instance).getExecutionMetadata());
                Checksum checksumValue = ((Droplet)instance).getChecksum();
                if (checksumValue != null) {
                    this.checksum(checksumValue);
                }
                this.state(((Droplet)instance).getState());
                String errorValue = ((Droplet)instance).getError();
                if (errorValue != null) {
                    this.error(errorValue);
                }
                if ((processTypesValue = ((Droplet)instance).getProcessTypes()) != null) {
                    this.putAllProcessTypes(processTypesValue);
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                this.updatedAt(instance.getUpdatedAt());
            }
        }

        public final Builder buildpack(Buildpack element) {
            if (this.buildpacks == null) {
                this.buildpacks = new ArrayList<Buildpack>();
            }
            this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
            return this;
        }

        public final Builder buildpack(Buildpack ... elements) {
            if (this.buildpacks == null) {
                this.buildpacks = new ArrayList<Buildpack>();
            }
            for (Buildpack element : elements) {
                this.buildpacks.add(Objects.requireNonNull(element, "buildpacks element"));
            }
            return this;
        }

        @JsonProperty(value="buildpacks")
        public final Builder buildpacks(@Nullable Iterable<? extends Buildpack> elements) {
            if (elements == null) {
                this.buildpacks = null;
                return this;
            }
            this.buildpacks = new ArrayList<Buildpack>();
            return this.addAllBuildpacks(elements);
        }

        public final Builder addAllBuildpacks(Iterable<? extends Buildpack> elements) {
            Objects.requireNonNull(elements, "buildpacks element");
            if (this.buildpacks == null) {
                this.buildpacks = new ArrayList<Buildpack>();
            }
            for (Buildpack buildpack : elements) {
                this.buildpacks.add(Objects.requireNonNull(buildpack, "buildpacks element"));
            }
            return this;
        }

        @JsonProperty(value="checksum")
        public final Builder checksum(@Nullable Checksum checksum) {
            this.checksum = checksum;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="execution_metadata")
        public final Builder executionMetadata(String executionMetadata) {
            this.executionMetadata = Objects.requireNonNull(executionMetadata, "executionMetadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="image")
        public final Builder image(@Nullable String image) {
            this.image = image;
            return this;
        }

        @JsonProperty(value="lifecycle")
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder processType(String key, String value) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            this.processTypes.put(Objects.requireNonNull(key, "processTypes key"), Objects.requireNonNull(value, "processTypes value"));
            return this;
        }

        public final Builder processType(Map.Entry<String, ? extends String> entry) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.processTypes.put(Objects.requireNonNull(k, "processTypes key"), Objects.requireNonNull(v, "processTypes value"));
            return this;
        }

        @JsonProperty(value="process_types")
        public final Builder processTypes(@Nullable Map<String, ? extends String> processTypes) {
            if (processTypes == null) {
                this.processTypes = null;
                return this;
            }
            this.processTypes = new LinkedHashMap<String, String>();
            return this.putAllProcessTypes(processTypes);
        }

        public final Builder putAllProcessTypes(Map<String, ? extends String> processTypes) {
            if (this.processTypes == null) {
                this.processTypes = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> entry : processTypes.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.processTypes.put(Objects.requireNonNull(k, "processTypes key"), Objects.requireNonNull(v, "processTypes value"));
            }
            return this;
        }

        @JsonProperty(value="stack")
        public final Builder stack(@Nullable String stack) {
            this.stack = stack;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(DropletState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> links) {
            this.links.clear();
            return this.putAllLinks(links);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> links) {
            for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
                String k = entry.getKey();
                Link v = entry.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public GetDropletResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetDropletResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("executionMetadata");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lifecycle");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("updatedAt");
            }
            return "Cannot build GetDropletResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _GetDropletResponse {
        List<Buildpack> buildpacks = null;
        Checksum checksum;
        String error;
        String executionMetadata;
        String image;
        Lifecycle lifecycle;
        Map<String, String> processTypes = null;
        String stack;
        DropletState state;
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;

        Json() {
        }

        @JsonProperty(value="buildpacks")
        public void setBuildpacks(@Nullable List<Buildpack> buildpacks) {
            this.buildpacks = buildpacks;
        }

        @JsonProperty(value="checksum")
        public void setChecksum(@Nullable Checksum checksum) {
            this.checksum = checksum;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="execution_metadata")
        public void setExecutionMetadata(String executionMetadata) {
            this.executionMetadata = executionMetadata;
        }

        @JsonProperty(value="image")
        public void setImage(@Nullable String image) {
            this.image = image;
        }

        @JsonProperty(value="lifecycle")
        public void setLifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        @JsonProperty(value="process_types")
        public void setProcessTypes(@Nullable Map<String, String> processTypes) {
            this.processTypes = processTypes;
        }

        @JsonProperty(value="stack")
        public void setStack(@Nullable String stack) {
            this.stack = stack;
        }

        @JsonProperty(value="state")
        public void setState(DropletState state) {
            this.state = state;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public List<Buildpack> getBuildpacks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Checksum getChecksum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExecutionMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getImage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Lifecycle getLifecycle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getProcessTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStack() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DropletState getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

