/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.processes._PortMapping;

public final class PortMapping
extends _PortMapping {
    private final Integer external;
    private final Integer internal;

    private PortMapping(Builder builder) {
        this.external = builder.external;
        this.internal = builder.internal;
    }

    @Override
    @JsonProperty(value="external")
    public Integer getExternal() {
        return this.external;
    }

    @Override
    @JsonProperty(value="internal")
    public Integer getInternal() {
        return this.internal;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PortMapping && this.equalTo((PortMapping)another);
    }

    private boolean equalTo(PortMapping another) {
        return this.external.equals(another.external) && this.internal.equals(another.internal);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.external.hashCode();
        h += (h << 5) + this.internal.hashCode();
        return h;
    }

    public String toString() {
        return "PortMapping{external=" + this.external + ", internal=" + this.internal + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static PortMapping fromJson(Json json) {
        Builder builder = PortMapping.builder();
        if (json.external != null) {
            builder.external(json.external);
        }
        if (json.internal != null) {
            builder.internal(json.internal);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXTERNAL = 1L;
        private static final long INIT_BIT_INTERNAL = 2L;
        private long initBits = 3L;
        private Integer external;
        private Integer internal;

        private Builder() {
        }

        public final Builder from(PortMapping instance) {
            return this.from((_PortMapping)instance);
        }

        final Builder from(_PortMapping instance) {
            Objects.requireNonNull(instance, "instance");
            this.external(instance.getExternal());
            this.internal(instance.getInternal());
            return this;
        }

        @JsonProperty(value="external")
        public final Builder external(Integer external) {
            this.external = Objects.requireNonNull(external, "external");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="internal")
        public final Builder internal(Integer internal) {
            this.internal = Objects.requireNonNull(internal, "internal");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public PortMapping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PortMapping(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("external");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("internal");
            }
            return "Cannot build PortMapping, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _PortMapping {
        Integer external;
        Integer internal;

        Json() {
        }

        @JsonProperty(value="external")
        public void setExternal(Integer external) {
            this.external = external;
        }

        @JsonProperty(value="internal")
        public void setInternal(Integer internal) {
            this.internal = internal;
        }

        @Override
        public Integer getExternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInternal() {
            throw new UnsupportedOperationException();
        }
    }
}

