/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.tasks._CreateTaskRequest;

public final class CreateTaskRequest
extends _CreateTaskRequest {
    private final String applicationId;
    private final String command;
    @Nullable
    private final String diskInMb;
    @Nullable
    private final String dropletId;
    @Nullable
    private final Integer memoryInMb;
    @Nullable
    private final String name;

    private CreateTaskRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.command = builder.command;
        this.diskInMb = builder.diskInMb;
        this.dropletId = builder.dropletId;
        this.memoryInMb = builder.memoryInMb;
        this.name = builder.name;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public String getDiskInMb() {
        return this.diskInMb;
    }

    @Override
    @Nullable
    public String getDropletId() {
        return this.dropletId;
    }

    @Override
    @Nullable
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateTaskRequest && this.equalTo((CreateTaskRequest)another);
    }

    private boolean equalTo(CreateTaskRequest another) {
        return this.applicationId.equals(another.applicationId) && this.command.equals(another.command) && Objects.equals(this.diskInMb, another.diskInMb) && Objects.equals(this.dropletId, another.dropletId) && Objects.equals(this.memoryInMb, another.memoryInMb) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + Objects.hashCode(this.diskInMb);
        h += (h << 5) + Objects.hashCode(this.dropletId);
        h += (h << 5) + Objects.hashCode(this.memoryInMb);
        h += (h << 5) + Objects.hashCode(this.name);
        return h;
    }

    public String toString() {
        return "CreateTaskRequest{applicationId=" + this.applicationId + ", command=" + this.command + ", diskInMb=" + this.diskInMb + ", dropletId=" + this.dropletId + ", memoryInMb=" + this.memoryInMb + ", name=" + this.name + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_COMMAND = 2L;
        private long initBits = 3L;
        private String applicationId;
        private String command;
        private String diskInMb;
        private String dropletId;
        private Integer memoryInMb;
        private String name;

        private Builder() {
        }

        public final Builder from(CreateTaskRequest instance) {
            return this.from((_CreateTaskRequest)instance);
        }

        final Builder from(_CreateTaskRequest instance) {
            String nameValue;
            Integer memoryInMbValue;
            String dropletIdValue;
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.command(instance.getCommand());
            String diskInMbValue = instance.getDiskInMb();
            if (diskInMbValue != null) {
                this.diskInMb(diskInMbValue);
            }
            if ((dropletIdValue = instance.getDropletId()) != null) {
                this.dropletId(dropletIdValue);
            }
            if ((memoryInMbValue = instance.getMemoryInMb()) != null) {
                this.memoryInMb(memoryInMbValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder diskInMb(@Nullable String diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        public final Builder dropletId(@Nullable String dropletId) {
            this.dropletId = dropletId;
            return this;
        }

        public final Builder memoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public CreateTaskRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateTaskRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("command");
            }
            return "Cannot build CreateTaskRequest, some of required attributes are not set " + attributes;
        }
    }
}

