/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients._BatchDeleteClientsRequest;
import org.immutables.value.Generated;

@Generated(from="_BatchDeleteClientsRequest", generator="Immutables")
public final class BatchDeleteClientsRequest
extends _BatchDeleteClientsRequest {
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;
    private final List<String> clientIds;

    private BatchDeleteClientsRequest(Builder builder) {
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
        this.clientIds = BatchDeleteClientsRequest.createUnmodifiableList(true, builder.clientIds);
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    @Override
    @JsonProperty(value="clientIds")
    @JsonIgnore
    public List<String> getClientIds() {
        return this.clientIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BatchDeleteClientsRequest && this.equalTo((BatchDeleteClientsRequest)another);
    }

    private boolean equalTo(BatchDeleteClientsRequest another) {
        return Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain) && this.clientIds.equals(another.clientIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        h += (h << 5) + this.clientIds.hashCode();
        return h;
    }

    public String toString() {
        return "BatchDeleteClientsRequest{identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + ", clientIds=" + this.clientIds + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BatchDeleteClientsRequest fromJson(Json json) {
        Builder builder = BatchDeleteClientsRequest.builder();
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        if (json.clientIds != null) {
            builder.addAllClientIds(json.clientIds);
        }
        return builder.build();
    }

    private static BatchDeleteClientsRequest validate(BatchDeleteClientsRequest instance) {
        instance.checkClientIds();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_BatchDeleteClientsRequest", generator="Immutables")
    public static final class Builder {
        private String identityZoneId;
        private String identityZoneSubdomain;
        private List<String> clientIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BatchDeleteClientsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_BatchDeleteClientsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _BatchDeleteClientsRequest) {
                instance = (_BatchDeleteClientsRequest)object;
                this.addAllClientIds(((_BatchDeleteClientsRequest)instance).getClientIds());
            }
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public final Builder clientId(String element) {
            this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            return this;
        }

        public final Builder clientIds(String ... elements) {
            for (String element : elements) {
                this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            }
            return this;
        }

        public final Builder clientIds(Iterable<String> elements) {
            this.clientIds.clear();
            return this.addAllClientIds(elements);
        }

        public final Builder addAllClientIds(Iterable<String> elements) {
            for (String element : elements) {
                this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
            }
            return this;
        }

        public BatchDeleteClientsRequest build() {
            return BatchDeleteClientsRequest.validate(new BatchDeleteClientsRequest(this));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_BatchDeleteClientsRequest", generator="Immutables")
    static final class Json
    extends _BatchDeleteClientsRequest {
        String identityZoneId;
        String identityZoneSubdomain;
        List<String> clientIds = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @JsonProperty(value="clientIds")
        @JsonIgnore
        public void setClientIds(List<String> clientIds) {
            this.clientIds = clientIds;
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getClientIds() {
            throw new UnsupportedOperationException();
        }
    }
}

