package org.cloudfoundry.operations.organizationadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Quota
 */
@Generated(from = "_OrganizationQuota", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class OrganizationQuota extends org.cloudfoundry.operations.organizationadmin._OrganizationQuota {
  private final Boolean allowPaidServicePlans;
  private final Integer applicationInstanceLimit;
  private final String id;
  private final Integer instanceMemoryLimit;
  private final Integer memoryLimit;
  private final String name;
  private final Integer totalReservedRoutePorts;
  private final Integer totalRoutes;
  private final Integer totalServices;

  private OrganizationQuota(OrganizationQuota.Builder builder) {
    this.allowPaidServicePlans = builder.allowPaidServicePlans;
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.id = builder.id;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServices = builder.totalServices;
  }

  /**
   * The allow paid service plans flag
   */
  @Override
  public Boolean getAllowPaidServicePlans() {
    return allowPaidServicePlans;
  }

  /**
   * The application instance limit
   */
  @Override
  public Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The instance memory limit
   */
  @Override
  public Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The memory limit
   */
  @Override
  public Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Maximum number of routes that may be created with reserved ports
   */
  @Override
  public Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * The total routes
   */
  @Override
  public Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * The total services
   */
  @Override
  public Integer getTotalServices() {
    return totalServices;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationQuota} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationQuota
        && equalTo((OrganizationQuota) another);
  }

  private boolean equalTo(OrganizationQuota another) {
    return allowPaidServicePlans.equals(another.allowPaidServicePlans)
        && applicationInstanceLimit.equals(another.applicationInstanceLimit)
        && id.equals(another.id)
        && instanceMemoryLimit.equals(another.instanceMemoryLimit)
        && memoryLimit.equals(another.memoryLimit)
        && name.equals(another.name)
        && totalReservedRoutePorts.equals(another.totalReservedRoutePorts)
        && totalRoutes.equals(another.totalRoutes)
        && totalServices.equals(another.totalServices);
  }

  /**
   * Computes a hash code from attributes: {@code allowPaidServicePlans}, {@code applicationInstanceLimit}, {@code id}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServices}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + allowPaidServicePlans.hashCode();
    h += (h << 5) + applicationInstanceLimit.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + instanceMemoryLimit.hashCode();
    h += (h << 5) + memoryLimit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + totalReservedRoutePorts.hashCode();
    h += (h << 5) + totalRoutes.hashCode();
    h += (h << 5) + totalServices.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationQuota} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationQuota{"
        + "allowPaidServicePlans=" + allowPaidServicePlans
        + ", applicationInstanceLimit=" + applicationInstanceLimit
        + ", id=" + id
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServices=" + totalServices
        + "}";
  }

  /**
   * Creates a builder for {@link OrganizationQuota OrganizationQuota}.
   * <pre>
   * OrganizationQuota.builder()
   *    .allowPaidServicePlans(Boolean) // required {@link OrganizationQuota#getAllowPaidServicePlans() allowPaidServicePlans}
   *    .applicationInstanceLimit(Integer) // required {@link OrganizationQuota#getApplicationInstanceLimit() applicationInstanceLimit}
   *    .id(String) // required {@link OrganizationQuota#getId() id}
   *    .instanceMemoryLimit(Integer) // required {@link OrganizationQuota#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .memoryLimit(Integer) // required {@link OrganizationQuota#getMemoryLimit() memoryLimit}
   *    .name(String) // required {@link OrganizationQuota#getName() name}
   *    .totalReservedRoutePorts(Integer) // required {@link OrganizationQuota#getTotalReservedRoutePorts() totalReservedRoutePorts}
   *    .totalRoutes(Integer) // required {@link OrganizationQuota#getTotalRoutes() totalRoutes}
   *    .totalServices(Integer) // required {@link OrganizationQuota#getTotalServices() totalServices}
   *    .build();
   * </pre>
   * @return A new OrganizationQuota builder
   */
  public static OrganizationQuota.Builder builder() {
    return new OrganizationQuota.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationQuota OrganizationQuota}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_OrganizationQuota", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ALLOW_PAID_SERVICE_PLANS = 0x1L;
    private static final long INIT_BIT_APPLICATION_INSTANCE_LIMIT = 0x2L;
    private static final long INIT_BIT_ID = 0x4L;
    private static final long INIT_BIT_INSTANCE_MEMORY_LIMIT = 0x8L;
    private static final long INIT_BIT_MEMORY_LIMIT = 0x10L;
    private static final long INIT_BIT_NAME = 0x20L;
    private static final long INIT_BIT_TOTAL_RESERVED_ROUTE_PORTS = 0x40L;
    private static final long INIT_BIT_TOTAL_ROUTES = 0x80L;
    private static final long INIT_BIT_TOTAL_SERVICES = 0x100L;
    private long initBits = 0x1ffL;

    private Boolean allowPaidServicePlans;
    private Integer applicationInstanceLimit;
    private String id;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServices;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationQuota} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationQuota instance) {
      return from((_OrganizationQuota) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationQuota} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationQuota instance) {
      Objects.requireNonNull(instance, "instance");
      allowPaidServicePlans(instance.getAllowPaidServicePlans());
      applicationInstanceLimit(instance.getApplicationInstanceLimit());
      id(instance.getId());
      instanceMemoryLimit(instance.getInstanceMemoryLimit());
      memoryLimit(instance.getMemoryLimit());
      name(instance.getName());
      totalReservedRoutePorts(instance.getTotalReservedRoutePorts());
      totalRoutes(instance.getTotalRoutes());
      totalServices(instance.getTotalServices());
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getAllowPaidServicePlans() allowPaidServicePlans} attribute.
     * @param allowPaidServicePlans The value for allowPaidServicePlans 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowPaidServicePlans(Boolean allowPaidServicePlans) {
      this.allowPaidServicePlans = Objects.requireNonNull(allowPaidServicePlans, "allowPaidServicePlans");
      initBits &= ~INIT_BIT_ALLOW_PAID_SERVICE_PLANS;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationInstanceLimit(Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = Objects.requireNonNull(applicationInstanceLimit, "applicationInstanceLimit");
      initBits &= ~INIT_BIT_APPLICATION_INSTANCE_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = Objects.requireNonNull(instanceMemoryLimit, "instanceMemoryLimit");
      initBits &= ~INIT_BIT_INSTANCE_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(Integer memoryLimit) {
      this.memoryLimit = Objects.requireNonNull(memoryLimit, "memoryLimit");
      initBits &= ~INIT_BIT_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalReservedRoutePorts(Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = Objects.requireNonNull(totalReservedRoutePorts, "totalReservedRoutePorts");
      initBits &= ~INIT_BIT_TOTAL_RESERVED_ROUTE_PORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(Integer totalRoutes) {
      this.totalRoutes = Objects.requireNonNull(totalRoutes, "totalRoutes");
      initBits &= ~INIT_BIT_TOTAL_ROUTES;
      return this;
    }

    /**
     * Initializes the value for the {@link OrganizationQuota#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServices(Integer totalServices) {
      this.totalServices = Objects.requireNonNull(totalServices, "totalServices");
      initBits &= ~INIT_BIT_TOTAL_SERVICES;
      return this;
    }

    /**
     * Builds a new {@link OrganizationQuota OrganizationQuota}.
     * @return An immutable instance of OrganizationQuota
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationQuota build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new OrganizationQuota(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ALLOW_PAID_SERVICE_PLANS) != 0) attributes.add("allowPaidServicePlans");
      if ((initBits & INIT_BIT_APPLICATION_INSTANCE_LIMIT) != 0) attributes.add("applicationInstanceLimit");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_INSTANCE_MEMORY_LIMIT) != 0) attributes.add("instanceMemoryLimit");
      if ((initBits & INIT_BIT_MEMORY_LIMIT) != 0) attributes.add("memoryLimit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TOTAL_RESERVED_ROUTE_PORTS) != 0) attributes.add("totalReservedRoutePorts");
      if ((initBits & INIT_BIT_TOTAL_ROUTES) != 0) attributes.add("totalRoutes");
      if ((initBits & INIT_BIT_TOTAL_SERVICES) != 0) attributes.add("totalServices");
      return "Cannot build OrganizationQuota, some of required attributes are not set " + attributes;
    }
  }
}
