package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the unset space role operation
 */
@Generated(from = "_UnsetSpaceRoleRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnsetSpaceRoleRequest extends org.cloudfoundry.operations.useradmin._UnsetSpaceRoleRequest {
  private final String organizationName;
  private final String spaceName;
  private final SpaceRole spaceRole;
  private final String username;

  private UnsetSpaceRoleRequest(UnsetSpaceRoleRequest.Builder builder) {
    this.organizationName = builder.organizationName;
    this.spaceName = builder.spaceName;
    this.spaceRole = builder.spaceRole;
    this.username = builder.username;
  }

  /**
   * Organization name
   */
  @Override
  public String getOrganizationName() {
    return organizationName;
  }

  /**
   * Space name
   */
  @Override
  public String getSpaceName() {
    return spaceName;
  }

  /**
   * Role
   */
  @Override
  public SpaceRole getSpaceRole() {
    return spaceRole;
  }

  /**
   * Username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code UnsetSpaceRoleRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnsetSpaceRoleRequest
        && equalTo((UnsetSpaceRoleRequest) another);
  }

  private boolean equalTo(UnsetSpaceRoleRequest another) {
    return organizationName.equals(another.organizationName)
        && spaceName.equals(another.spaceName)
        && spaceRole.equals(another.spaceRole)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code organizationName}, {@code spaceName}, {@code spaceRole}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationName.hashCode();
    h += (h << 5) + spaceName.hashCode();
    h += (h << 5) + spaceRole.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnsetSpaceRoleRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnsetSpaceRoleRequest{"
        + "organizationName=" + organizationName
        + ", spaceName=" + spaceName
        + ", spaceRole=" + spaceRole
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link UnsetSpaceRoleRequest UnsetSpaceRoleRequest}.
   * <pre>
   * UnsetSpaceRoleRequest.builder()
   *    .organizationName(String) // required {@link UnsetSpaceRoleRequest#getOrganizationName() organizationName}
   *    .spaceName(String) // required {@link UnsetSpaceRoleRequest#getSpaceName() spaceName}
   *    .spaceRole(org.cloudfoundry.operations.useradmin.SpaceRole) // required {@link UnsetSpaceRoleRequest#getSpaceRole() spaceRole}
   *    .username(String) // required {@link UnsetSpaceRoleRequest#getUsername() username}
   *    .build();
   * </pre>
   * @return A new UnsetSpaceRoleRequest builder
   */
  public static UnsetSpaceRoleRequest.Builder builder() {
    return new UnsetSpaceRoleRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnsetSpaceRoleRequest UnsetSpaceRoleRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnsetSpaceRoleRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_NAME = 0x1L;
    private static final long INIT_BIT_SPACE_NAME = 0x2L;
    private static final long INIT_BIT_SPACE_ROLE = 0x4L;
    private static final long INIT_BIT_USERNAME = 0x8L;
    private long initBits = 0xfL;

    private String organizationName;
    private String spaceName;
    private SpaceRole spaceRole;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnsetSpaceRoleRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnsetSpaceRoleRequest instance) {
      return from((_UnsetSpaceRoleRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UnsetSpaceRoleRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnsetSpaceRoleRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationName(instance.getOrganizationName());
      spaceName(instance.getSpaceName());
      spaceRole(instance.getSpaceRole());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link UnsetSpaceRoleRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(String organizationName) {
      this.organizationName = Objects.requireNonNull(organizationName, "organizationName");
      initBits &= ~INIT_BIT_ORGANIZATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UnsetSpaceRoleRequest#getSpaceName() spaceName} attribute.
     * @param spaceName The value for spaceName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceName(String spaceName) {
      this.spaceName = Objects.requireNonNull(spaceName, "spaceName");
      initBits &= ~INIT_BIT_SPACE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UnsetSpaceRoleRequest#getSpaceRole() spaceRole} attribute.
     * @param spaceRole The value for spaceRole 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceRole(SpaceRole spaceRole) {
      this.spaceRole = Objects.requireNonNull(spaceRole, "spaceRole");
      initBits &= ~INIT_BIT_SPACE_ROLE;
      return this;
    }

    /**
     * Initializes the value for the {@link UnsetSpaceRoleRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link UnsetSpaceRoleRequest UnsetSpaceRoleRequest}.
     * @return An immutable instance of UnsetSpaceRoleRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnsetSpaceRoleRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnsetSpaceRoleRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORGANIZATION_NAME) != 0) attributes.add("organizationName");
      if ((initBits & INIT_BIT_SPACE_NAME) != 0) attributes.add("spaceName");
      if ((initBits & INIT_BIT_SPACE_ROLE) != 0) attributes.add("spaceRole");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build UnsetSpaceRoleRequest, some of required attributes are not set " + attributes;
    }
  }
}
