/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cloudfoundry.util.TimeUtils;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public final class OperationsLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.operations");

    private OperationsLogging() {
    }

    public static <T extends Publisher<U>, U> Function<T, T> log(String message) {
        if (!LOGGER.isDebugEnabled()) {
            return f -> f;
        }
        AtomicLong startTimeHolder = new AtomicLong();
        Consumer<Subscription> start = subscription -> {
            startTimeHolder.set(System.currentTimeMillis());
            LOGGER.debug("START  {}", (Object)message);
        };
        Consumer<SignalType> finish = signalType -> {
            String elapsed = TimeUtils.asTime((long)(System.currentTimeMillis() - startTimeHolder.get()));
            LOGGER.debug("FINISH {} ({}/{})", new Object[]{message, signalType, elapsed});
        };
        return f -> {
            if (f instanceof Mono) {
                return ((Mono)f).doOnSubscribe(start).doFinally(finish);
            }
            if (f instanceof Flux) {
                return ((Flux)f).doOnSubscribe(start).doFinally(finish);
            }
            return f;
        };
    }
}

