/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudfoundry.client.v2.securitygroups.CreateSecurityGroupRequest;
import org.cloudfoundry.client.v2.securitygroups.Protocol;
import org.cloudfoundry.client.v2.securitygroups.RuleEntity;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.applications.LogsRequest;
import org.cloudfoundry.operations.applications.SetEnvironmentVariableApplicationRequest;
import org.cloudfoundry.operations.applications.StartApplicationRequest;
import org.cloudfoundry.operations.applications.StopApplicationRequest;
import org.cloudfoundry.operations.organizations.CreateOrganizationRequest;
import org.cloudfoundry.operations.organizations.OrganizationSummary;
import org.cloudfoundry.operations.routes.MapRouteRequest;
import org.cloudfoundry.operations.routes.UnmapRouteRequest;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.cloudfoundry.operations.services.CreateServiceInstanceRequest;
import org.cloudfoundry.operations.services.CreateUserProvidedServiceInstanceRequest;
import org.cloudfoundry.operations.services.ServiceInstanceSummary;
import org.cloudfoundry.operations.services.UpdateUserProvidedServiceInstanceRequest;
import org.cloudfoundry.operations.spaces.CreateSpaceRequest;
import org.cloudfoundry.operations.spaces.GetSpaceRequest;
import org.cloudfoundry.operations.spaces.SpaceDetail;
import org.cloudfoundry.operations.spaces.SpaceSummary;
import org.cloudfoundry.tools.pushapps.CloudFoundryClient;
import org.cloudfoundry.tools.pushapps.CloudFoundryClientKt$sam$Function$aa46170b;
import org.cloudfoundry.tools.pushapps.CloudFoundryOperationsBuilder;
import org.cloudfoundry.tools.pushapps.PushApplication;
import org.cloudfoundry.tools.pushapps.config.AppConfig;
import org.cloudfoundry.tools.pushapps.config.SecurityGroup;
import org.cloudfoundry.tools.pushapps.config.ServiceConfig;
import org.cloudfoundry.tools.pushapps.config.UserProvidedServiceConfig;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fJ0\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00160\u001aH\u0002J0\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0010\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00100\u001aH\u0002J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0013J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0013H\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0013J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010)\u001a\u00020*J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010)\u001a\u00020.J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00162\u0006\u0010\u0012\u001a\u00020\u0013J$\u00101\u001a\b\u0012\u0004\u0012\u0002020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002040\u000f2\u0006\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u001f\u001a\u00020\u0013J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u00105\u001a\u000206J\u0010\u0010=\u001a\u00020>2\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u00105\u001a\u000206J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u00105\u001a\u000206J\u0010\u0010A\u001a\u00020>2\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010D\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0010\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0013H\u0002J\u0014\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u00105\u001a\u000206J\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010)\u001a\u00020.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/cloudfoundry/tools/pushapps/CloudFoundryClient;", "", "cloudFoundryOperations", "Lorg/cloudfoundry/operations/CloudFoundryOperations;", "cloudFoundryOperationsBuilder", "Lorg/cloudfoundry/tools/pushapps/CloudFoundryOperationsBuilder;", "operationTimeoutInMinutes", "", "retryCount", "", "(Lorg/cloudfoundry/operations/CloudFoundryOperations;Lorg/cloudfoundry/tools/pushapps/CloudFoundryOperationsBuilder;JI)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "bindServicesToApplication", "", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "appName", "", "serviceNames", "buildFluxCfOperationWithRetries", "Lreactor/core/publisher/Flux;", "T", "numberOfRetries", "operation", "Lkotlin/Function0;", "buildMonoCfOperationWithRetries", "createAndTargetOrganization", "organizationName", "createAndTargetSpace", "spaceName", "createOrganization", "name", "createOrganizationIfDoesNotExist", "", "createSecurityGroup", "securityGroup", "Lorg/cloudfoundry/tools/pushapps/config/SecurityGroup;", "spaceId", "createService", "serviceConfig", "Lorg/cloudfoundry/tools/pushapps/config/ServiceConfig;", "createSpace", "createSpaceIfDoesNotExist", "createUserProvidedService", "Lorg/cloudfoundry/tools/pushapps/config/UserProvidedServiceConfig;", "fetchRecentLogsForAsync", "Lorg/cloudfoundry/doppler/LogMessage;", "generateBindServiceRequests", "Lorg/cloudfoundry/operations/services/BindServiceInstanceRequest;", "generateSetEnvRequests", "Lorg/cloudfoundry/operations/applications/SetEnvironmentVariableApplicationRequest;", "appConfig", "Lorg/cloudfoundry/tools/pushapps/config/AppConfig;", "getSpaceId", "listApplications", "listOrganizations", "listServices", "listSpaces", "mapRoute", "organizationDoesExist", "", "pushApplication", "setApplicationEnvironment", "spaceDoesExist", "startApplication", "stopApplication", "targetOrganization", "targetSpace", "space", "unmapRoute", "updateUserProvidedService", "push-apps"})
public final class CloudFoundryClient {
    private final Logger logger;
    private CloudFoundryOperations cloudFoundryOperations;
    private final CloudFoundryOperationsBuilder cloudFoundryOperationsBuilder;
    private final long operationTimeoutInMinutes;
    private final int retryCount;

    private final <T> Mono<T> buildMonoCfOperationWithRetries(int numberOfRetries, Function0<? extends Mono<T>> operation) {
        if (numberOfRetries == 0) {
            Mono mono = ((Mono)operation.invoke()).timeout(Duration.ofMinutes(this.operationTimeoutInMinutes));
            Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"operation()\n            \u2026erationTimeoutInMinutes))");
            return mono;
        }
        Mono mono = ((Mono)operation.invoke()).timeout(Duration.ofMinutes(this.operationTimeoutInMinutes)).onErrorResume(new Function<Throwable, Mono<? extends T>>(this, numberOfRetries, operation){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ int $numberOfRetries;
            final /* synthetic */ Function0 $operation;

            @NotNull
            public final Mono<T> apply(Throwable error) {
                CloudFoundryClient.access$getLogger$p(this.this$0).debug("Resuming operation due to error " + error.getMessage());
                return CloudFoundryClient.access$buildMonoCfOperationWithRetries(this.this$0, this.$numberOfRetries - 1, this.$operation);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$numberOfRetries = n;
                this.$operation = function0;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"operation()\n            \u2026 operation)\n            }");
        return mono;
    }

    private final <T> Flux<T> buildFluxCfOperationWithRetries(int numberOfRetries, Function0<? extends Flux<T>> operation) {
        if (numberOfRetries == 0) {
            Flux flux = ((Flux)operation.invoke()).timeout(Duration.ofMinutes(this.operationTimeoutInMinutes));
            Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"operation().timeout(Dura\u2026erationTimeoutInMinutes))");
            return flux;
        }
        Flux flux = ((Flux)operation.invoke()).timeout(Duration.ofMinutes(this.operationTimeoutInMinutes)).onErrorResume(new Function<Throwable, Publisher<? extends T>>(this, numberOfRetries, operation){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ int $numberOfRetries;
            final /* synthetic */ Function0 $operation;

            @NotNull
            public final Flux<T> apply(Throwable error) {
                CloudFoundryClient.access$getLogger$p(this.this$0).debug("Resuming operation due to error " + error.getMessage());
                return CloudFoundryClient.access$buildFluxCfOperationWithRetries(this.this$0, this.$numberOfRetries - 1, this.$operation);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$numberOfRetries = n;
                this.$operation = function0;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"operation()\n            \u2026 operation)\n            }");
        return flux;
    }

    @NotNull
    public final Mono<Void> createService(@NotNull ServiceConfig serviceConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serviceConfig, (String)"serviceConfig");
        CreateServiceInstanceRequest createServiceRequest = CreateServiceInstanceRequest.builder().serviceInstanceName(serviceConfig.getName()).planName(serviceConfig.getPlan()).serviceName(serviceConfig.getBroker()).build();
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, createServiceRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ CreateServiceInstanceRequest $createServiceRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).services().createInstance(this.$createServiceRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$createServiceRequest = createServiceInstanceRequest;
                super(0);
            }
        });
    }

    @NotNull
    public final Mono<Void> createUserProvidedService(@NotNull UserProvidedServiceConfig serviceConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serviceConfig, (String)"serviceConfig");
        CreateUserProvidedServiceInstanceRequest createServiceRequest = CreateUserProvidedServiceInstanceRequest.builder().name(serviceConfig.getName()).credentials(serviceConfig.getCredentials()).build();
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, createServiceRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ CreateUserProvidedServiceInstanceRequest $createServiceRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).services().createUserProvidedInstance(this.$createServiceRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$createServiceRequest = createUserProvidedServiceInstanceRequest;
                super(0);
            }
        });
    }

    @NotNull
    public final Mono<Void> updateUserProvidedService(@NotNull UserProvidedServiceConfig serviceConfig) {
        Intrinsics.checkParameterIsNotNull((Object)serviceConfig, (String)"serviceConfig");
        UpdateUserProvidedServiceInstanceRequest updateServiceRequest = UpdateUserProvidedServiceInstanceRequest.builder().userProvidedServiceInstanceName(serviceConfig.getName()).credentials(serviceConfig.getCredentials()).build();
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, updateServiceRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ UpdateUserProvidedServiceInstanceRequest $updateServiceRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).services().updateUserProvidedInstance(this.$updateServiceRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$updateServiceRequest = updateUserProvidedServiceInstanceRequest;
                super(0);
            }
        });
    }

    @NotNull
    public final Mono<Void> pushApplication(@NotNull AppConfig appConfig) {
        Intrinsics.checkParameterIsNotNull((Object)appConfig, (String)"appConfig");
        PushApplication pushApplication2 = new PushApplication(this.cloudFoundryOperations, appConfig);
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(pushApplication2){
            final /* synthetic */ PushApplication $pushApplication;

            @NotNull
            public final Mono<Void> invoke() {
                return this.$pushApplication.generatePushAppAction();
            }
            {
                this.$pushApplication = pushApplication2;
                super(0);
            }
        });
    }

    @NotNull
    public final Mono<Void> startApplication(@NotNull String appName) {
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        StartApplicationRequest startApplicationRequest = StartApplicationRequest.builder().name(appName).stagingTimeout(Duration.ofMinutes(10L)).build();
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, startApplicationRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ StartApplicationRequest $startApplicationRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).applications().start(this.$startApplicationRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$startApplicationRequest = startApplicationRequest;
                super(0);
            }
        });
    }

    @NotNull
    public final Mono<Void> stopApplication(@NotNull String appName) {
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        StopApplicationRequest stopApplicationRequest = StopApplicationRequest.builder().name(appName).build();
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, stopApplicationRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ StopApplicationRequest $stopApplicationRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).applications().stop(this.$stopApplicationRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$stopApplicationRequest = stopApplicationRequest;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Mono<Void> setApplicationEnvironment(@NotNull AppConfig appConfig) {
        void $receiver$iv;
        Mono initial$iv;
        List<SetEnvironmentVariableApplicationRequest> setEnvRequests;
        Intrinsics.checkParameterIsNotNull((Object)appConfig, (String)"appConfig");
        List<SetEnvironmentVariableApplicationRequest> list = setEnvRequests = this.generateSetEnvRequests(appConfig);
        Mono accumulator$iv = initial$iv = Mono.empty();
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                void memo;
                Mono mono = accumulator$iv;
                SetEnvironmentVariableApplicationRequest request = (SetEnvironmentVariableApplicationRequest)iterator$iv.previous();
                Mono monoCfOperationWithRetries = this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(request, this){
                    final /* synthetic */ SetEnvironmentVariableApplicationRequest $request;
                    final /* synthetic */ CloudFoundryClient this$0;
                    {
                        this.$request = setEnvironmentVariableApplicationRequest;
                        this.this$0 = cloudFoundryClient;
                        super(0);
                    }

                    public final Mono<Void> invoke() {
                        return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).applications().setEnvironmentVariable(this.$request);
                    }
                });
                accumulator$iv = memo.then(monoCfOperationWithRetries);
            }
        }
        Mono mono = accumulator$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"setEnvRequests.foldRight\u2026onWithRetries)\n        })");
        return mono;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SetEnvironmentVariableApplicationRequest> generateSetEnvRequests(AppConfig appConfig) {
        void $receiver$iv$iv;
        Map<String, String> $receiver$iv;
        if (appConfig.getEnvironment() == null) {
            return CollectionsKt.emptyList();
        }
        Map<String, String> map2 = $receiver$iv = appConfig.getEnvironment();
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var5_5 = $receiver$iv$iv;
        Iterator iterator = var5_5.entrySet().iterator();
        while (iterator.hasNext()) {
            SetEnvironmentVariableApplicationRequest setEnvironmentVariableApplicationRequest;
            void variable;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            if ((String)variable.getValue() == null) {
                setEnvironmentVariableApplicationRequest = null;
            } else {
                String value;
                CharSequence charSequence = value;
                if (charSequence.length() == 0) {
                    this.logger.debug("Setting environment variable " + (String)variable.getKey() + " to empty string");
                }
                setEnvironmentVariableApplicationRequest = SetEnvironmentVariableApplicationRequest.builder().name(appConfig.getName()).variableName((String)variable.getKey()).variableValue(value).build();
            }
            SetEnvironmentVariableApplicationRequest setEnvironmentVariableApplicationRequest2 = setEnvironmentVariableApplicationRequest;
            collection.add(setEnvironmentVariableApplicationRequest2);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Mono<Void>> bindServicesToApplication(@NotNull String appName, @NotNull List<String> serviceNames) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        Intrinsics.checkParameterIsNotNull(serviceNames, (String)"serviceNames");
        List<BindServiceInstanceRequest> bindServiceRequests = this.generateBindServiceRequests(appName, serviceNames);
        Iterable iterable = $receiver$iv = (Iterable)bindServiceRequests;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void request;
            BindServiceInstanceRequest bindServiceInstanceRequest = (BindServiceInstanceRequest)item$iv$iv;
            Collection collection = destination$iv$iv;
            Mono mono = this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>((BindServiceInstanceRequest)request, this){
                final /* synthetic */ BindServiceInstanceRequest $request;
                final /* synthetic */ CloudFoundryClient this$0;
                {
                    this.$request = bindServiceInstanceRequest;
                    this.this$0 = cloudFoundryClient;
                    super(0);
                }

                public final Mono<Void> invoke() {
                    return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).services().bind(this.$request);
                }
            });
            collection.add(mono);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BindServiceInstanceRequest> generateBindServiceRequests(String appName, List<String> serviceNames) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)serviceNames;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void serviceName;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            BindServiceInstanceRequest bindServiceInstanceRequest = BindServiceInstanceRequest.builder().applicationName(appName).serviceInstanceName((String)serviceName).build();
            collection.add(bindServiceInstanceRequest);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Mono<Void> mapRoute(@NotNull AppConfig appConfig) {
        Intrinsics.checkParameterIsNotNull((Object)appConfig, (String)"appConfig");
        if (appConfig.getRoute() == null) {
            Mono mono = Mono.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"Mono.empty()");
            return mono;
        }
        String route = "http://" + appConfig.getRoute().getHostname() + '.' + appConfig.getDomain();
        MapRouteRequest.Builder mapRouteRequestBuilder = MapRouteRequest.builder().applicationName(appConfig.getName()).domain(appConfig.getDomain()).host(appConfig.getRoute().getHostname());
        if (appConfig.getRoute().getPath() != null) {
            mapRouteRequestBuilder.path(appConfig.getRoute().getPath());
            route = route + '/' + appConfig.getRoute().getPath();
        }
        MapRouteRequest mapRouteRequest = mapRouteRequestBuilder.build();
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, mapRouteRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ MapRouteRequest $mapRouteRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).routes().map(this.$mapRouteRequest).ofType(Void.TYPE);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$mapRouteRequest = mapRouteRequest;
                super(0);
            }
        });
    }

    @NotNull
    public final Mono<Void> unmapRoute(@NotNull AppConfig appConfig) {
        Intrinsics.checkParameterIsNotNull((Object)appConfig, (String)"appConfig");
        if (appConfig.getRoute() == null) {
            Mono mono = Mono.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"Mono.empty()");
            return mono;
        }
        UnmapRouteRequest.Builder unmapRouteRequestBuilder = UnmapRouteRequest.builder().applicationName(appConfig.getName()).domain(appConfig.getDomain()).host(appConfig.getRoute().getHostname());
        if (appConfig.getRoute().getPath() != null) {
            unmapRouteRequestBuilder.path(appConfig.getRoute().getPath());
        }
        UnmapRouteRequest unmapRouteRequest = unmapRouteRequestBuilder.build();
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, unmapRouteRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ UnmapRouteRequest $unmapRouteRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).routes().unmap(this.$unmapRouteRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$unmapRouteRequest = unmapRouteRequest;
                super(0);
            }
        });
    }

    @NotNull
    public final Mono<Void> createSecurityGroup(@NotNull SecurityGroup securityGroup, @NotNull String spaceId) {
        Intrinsics.checkParameterIsNotNull((Object)securityGroup, (String)"securityGroup");
        Intrinsics.checkParameterIsNotNull((Object)spaceId, (String)"spaceId");
        RuleEntity rule = RuleEntity.builder().destination(securityGroup.getDestination()).protocol(Protocol.from((String)securityGroup.getProtocol())).build();
        CreateSecurityGroupRequest createSecurityGroupRequest = CreateSecurityGroupRequest.builder().name(securityGroup.getName()).rule(rule).spaceId(spaceId).build();
        CloudFoundryOperations cloudFoundryOperations = this.cloudFoundryOperations;
        if (cloudFoundryOperations == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.cloudfoundry.operations.DefaultCloudFoundryOperations");
        }
        DefaultCloudFoundryOperations defaultCloudFoundryOperations = (DefaultCloudFoundryOperations)cloudFoundryOperations;
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(defaultCloudFoundryOperations, createSecurityGroupRequest){
            final /* synthetic */ DefaultCloudFoundryOperations $defaultCloudFoundryOperations;
            final /* synthetic */ CreateSecurityGroupRequest $createSecurityGroupRequest;

            public final Mono<Void> invoke() {
                return this.$defaultCloudFoundryOperations.getCloudFoundryClient().securityGroups().create(this.$createSecurityGroupRequest).ofType(Void.TYPE);
            }
            {
                this.$defaultCloudFoundryOperations = defaultCloudFoundryOperations;
                this.$createSecurityGroupRequest = createSecurityGroupRequest;
                super(0);
            }
        });
    }

    @NotNull
    public final CloudFoundryClient createAndTargetOrganization(@NotNull String organizationName) {
        Intrinsics.checkParameterIsNotNull((Object)organizationName, (String)"organizationName");
        this.createOrganizationIfDoesNotExist(organizationName);
        return this.targetOrganization(organizationName);
    }

    private final void createOrganizationIfDoesNotExist(String name) {
        if (!this.organizationDoesExist(name)) {
            this.createOrganization(name).block();
        }
    }

    private final boolean organizationDoesExist(String name) {
        Iterable iterable = this.listOrganizations().toIterable();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"listOrganizations().toIterable()");
        return CollectionsKt.indexOf((Iterable)iterable, (Object)name) != -1;
    }

    private final Mono<Void> createOrganization(String name) {
        CreateOrganizationRequest createOrganizationRequest = CreateOrganizationRequest.builder().organizationName(name).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)createOrganizationRequest, (String)"CreateOrganizationReques\u2026ame)\n            .build()");
        CreateOrganizationRequest createOrganizationRequest2 = createOrganizationRequest;
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, createOrganizationRequest2){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ CreateOrganizationRequest $createOrganizationRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).organizations().create(this.$createOrganizationRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$createOrganizationRequest = createOrganizationRequest;
                super(0);
            }
        });
    }

    private final CloudFoundryClient targetOrganization(String organizationName) {
        CloudFoundryOperationsBuilder cloudFoundryOperationsBuilder = this.cloudFoundryOperationsBuilder.fromExistingOperations(this.cloudFoundryOperations);
        CloudFoundryClient cloudFoundryClient = this;
        CloudFoundryOperationsBuilder $receiver = cloudFoundryOperationsBuilder;
        $receiver.setOrganization(organizationName);
        CloudFoundryOperationsBuilder cloudFoundryOperationsBuilder2 = cloudFoundryOperationsBuilder;
        cloudFoundryClient.cloudFoundryOperations = cloudFoundryOperationsBuilder2.build();
        return this;
    }

    @NotNull
    public final CloudFoundryClient createAndTargetSpace(@NotNull String spaceName) {
        Intrinsics.checkParameterIsNotNull((Object)spaceName, (String)"spaceName");
        this.createSpaceIfDoesNotExist(spaceName);
        return this.targetSpace(spaceName);
    }

    private final void createSpaceIfDoesNotExist(String name) {
        if (!this.spaceDoesExist(name)) {
            this.createSpace(name).block();
        }
    }

    private final boolean spaceDoesExist(String name) {
        Iterable iterable = this.listSpaces().toIterable();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"listSpaces().toIterable()");
        return CollectionsKt.toList((Iterable)iterable).indexOf(name) != -1;
    }

    private final Mono<Void> createSpace(String name) {
        CreateSpaceRequest createSpaceRequest = CreateSpaceRequest.builder().name(name).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)createSpaceRequest, (String)"CreateSpaceRequest\n     \u2026ame)\n            .build()");
        CreateSpaceRequest createSpaceRequest2 = createSpaceRequest;
        return this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<Void>>(this, createSpaceRequest2){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ CreateSpaceRequest $createSpaceRequest;

            public final Mono<Void> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).spaces().create(this.$createSpaceRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$createSpaceRequest = createSpaceRequest;
                super(0);
            }
        });
    }

    private final CloudFoundryClient targetSpace(String space) {
        CloudFoundryOperationsBuilder cloudFoundryOperationsBuilder = this.cloudFoundryOperationsBuilder.fromExistingOperations(this.cloudFoundryOperations);
        CloudFoundryClient cloudFoundryClient = this;
        CloudFoundryOperationsBuilder $receiver = cloudFoundryOperationsBuilder;
        $receiver.setSpace(space);
        CloudFoundryOperationsBuilder cloudFoundryOperationsBuilder2 = cloudFoundryOperationsBuilder;
        cloudFoundryClient.cloudFoundryOperations = cloudFoundryOperationsBuilder2.build();
        return this;
    }

    @NotNull
    public final Flux<String> listOrganizations() {
        Flux flux = this.buildFluxCfOperationWithRetries(this.retryCount, (Function0)new Function0<Flux<OrganizationSummary>>(this){
            final /* synthetic */ CloudFoundryClient this$0;

            public final Flux<OrganizationSummary> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).organizations().list();
            }
            {
                this.this$0 = cloudFoundryClient;
                super(0);
            }
        });
        Object object = listOrganizations.2.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new CloudFoundryClientKt$sam$Function$aa46170b(function1);
        }
        Flux flux2 = flux.map((Function)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)flux2, (String)"buildFluxCfOperationWith\u2026nizationSummary::getName)");
        return flux2;
    }

    @NotNull
    public final Flux<String> listSpaces() {
        Flux flux = this.buildFluxCfOperationWithRetries(this.retryCount, (Function0)new Function0<Flux<SpaceSummary>>(this){
            final /* synthetic */ CloudFoundryClient this$0;

            public final Flux<SpaceSummary> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).spaces().list();
            }
            {
                this.this$0 = cloudFoundryClient;
                super(0);
            }
        });
        Object object = listSpaces.2.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new CloudFoundryClientKt$sam$Function$aa46170b(function1);
        }
        Flux flux2 = flux.map((Function)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)flux2, (String)"buildFluxCfOperationWith\u2026ap(SpaceSummary::getName)");
        return flux2;
    }

    @NotNull
    public final Flux<String> listServices() {
        Flux flux = this.buildFluxCfOperationWithRetries(this.retryCount, (Function0)new Function0<Flux<ServiceInstanceSummary>>(this){
            final /* synthetic */ CloudFoundryClient this$0;

            public final Flux<ServiceInstanceSummary> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).services().listInstances();
            }
            {
                this.this$0 = cloudFoundryClient;
                super(0);
            }
        });
        Object object = listServices.2.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new CloudFoundryClientKt$sam$Function$aa46170b(function1);
        }
        Flux flux2 = flux.map((Function)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)flux2, (String)"buildFluxCfOperationWith\u2026InstanceSummary::getName)");
        return flux2;
    }

    @NotNull
    public final Flux<String> listApplications() {
        Flux flux = this.buildFluxCfOperationWithRetries(this.retryCount, (Function0)new Function0<Flux<ApplicationSummary>>(this){
            final /* synthetic */ CloudFoundryClient this$0;

            public final Flux<ApplicationSummary> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).applications().list();
            }
            {
                this.this$0 = cloudFoundryClient;
                super(0);
            }
        });
        Object object = listApplications.2.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new CloudFoundryClientKt$sam$Function$aa46170b(function1);
        }
        Flux flux2 = flux.map((Function)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)flux2, (String)"buildFluxCfOperationWith\u2026licationSummary::getName)");
        return flux2;
    }

    @NotNull
    public final Mono<String> getSpaceId(@NotNull String spaceName) {
        Intrinsics.checkParameterIsNotNull((Object)spaceName, (String)"spaceName");
        GetSpaceRequest spaceRequest = GetSpaceRequest.builder().name(spaceName).build();
        Mono mono = this.buildMonoCfOperationWithRetries(this.retryCount, (Function0)new Function0<Mono<SpaceDetail>>(this, spaceRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ GetSpaceRequest $spaceRequest;

            public final Mono<SpaceDetail> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).spaces().get(this.$spaceRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$spaceRequest = getSpaceRequest;
                super(0);
            }
        });
        Object object = getSpaceId.2.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new CloudFoundryClientKt$sam$Function$aa46170b(function1);
        }
        Mono mono2 = mono.map((Function)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono2, (String)"buildMonoCfOperationWith\u2026}.map(SpaceDetail::getId)");
        return mono2;
    }

    @NotNull
    public final Flux<LogMessage> fetchRecentLogsForAsync(@NotNull String appName) {
        Intrinsics.checkParameterIsNotNull((Object)appName, (String)"appName");
        LogsRequest logsRequest = LogsRequest.builder().name(appName).recent(Boolean.valueOf(true)).build();
        return this.buildFluxCfOperationWithRetries(this.retryCount, (Function0)new Function0<Flux<LogMessage>>(this, logsRequest){
            final /* synthetic */ CloudFoundryClient this$0;
            final /* synthetic */ LogsRequest $logsRequest;

            public final Flux<LogMessage> invoke() {
                return CloudFoundryClient.access$getCloudFoundryOperations$p(this.this$0).applications().logs(this.$logsRequest);
            }
            {
                this.this$0 = cloudFoundryClient;
                this.$logsRequest = logsRequest;
                super(0);
            }
        });
    }

    public CloudFoundryClient(@NotNull CloudFoundryOperations cloudFoundryOperations, @NotNull CloudFoundryOperationsBuilder cloudFoundryOperationsBuilder, long operationTimeoutInMinutes, int retryCount) {
        Intrinsics.checkParameterIsNotNull((Object)cloudFoundryOperations, (String)"cloudFoundryOperations");
        Intrinsics.checkParameterIsNotNull((Object)cloudFoundryOperationsBuilder, (String)"cloudFoundryOperationsBuilder");
        this.cloudFoundryOperations = cloudFoundryOperations;
        this.cloudFoundryOperationsBuilder = cloudFoundryOperationsBuilder;
        this.operationTimeoutInMinutes = operationTimeoutInMinutes;
        this.retryCount = retryCount;
        this.logger = LogManager.getLogger(CloudFoundryClient.class);
    }

    public static final /* synthetic */ Logger access$getLogger$p(CloudFoundryClient $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ Mono access$buildMonoCfOperationWithRetries(CloudFoundryClient $this, int numberOfRetries, @NotNull Function0 operation) {
        return $this.buildMonoCfOperationWithRetries(numberOfRetries, operation);
    }

    @NotNull
    public static final /* synthetic */ Flux access$buildFluxCfOperationWithRetries(CloudFoundryClient $this, int numberOfRetries, @NotNull Function0 operation) {
        return $this.buildFluxCfOperationWithRetries(numberOfRetries, operation);
    }

    @NotNull
    public static final /* synthetic */ CloudFoundryOperations access$getCloudFoundryOperations$p(CloudFoundryClient $this) {
        return $this.cloudFoundryOperations;
    }

    public static final /* synthetic */ void access$setCloudFoundryOperations$p(CloudFoundryClient $this, @NotNull CloudFoundryOperations cloudFoundryOperations) {
        $this.cloudFoundryOperations = cloudFoundryOperations;
    }
}

