/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps;

import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cloudfoundry.tools.pushapps.DataSourceBuilder;
import org.cloudfoundry.tools.pushapps.config.DatabaseDriver;
import org.cloudfoundry.tools.pushapps.config.Migration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B[\u0012)\b\u0002\u0010\u0002\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t\u0012)\b\u0002\u0010\n\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002R/\u0010\u0002\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\n\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/cloudfoundry/tools/pushapps/DataSourceFactory;", "", "mySqlBuilder", "Lkotlin/Function1;", "Ljavax/sql/DataSource;", "Lkotlin/ParameterName;", "name", "dataSource", "Lorg/cloudfoundry/tools/pushapps/DataSourceBuilder;", "Lorg/cloudfoundry/tools/pushapps/GetDataSourceBuilder;", "postgresBuilder", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "addDatabaseNameToDataSource", "migration", "Lorg/cloudfoundry/tools/pushapps/config/Migration;", "buildDataSource", "buildMysqlDataSource", "buildPostgresDataSource", "push-apps"})
public final class DataSourceFactory {
    private final Function1<DataSource, DataSourceBuilder> mySqlBuilder;
    private final Function1<DataSource, DataSourceBuilder> postgresBuilder;

    @NotNull
    public final DataSource buildDataSource(@NotNull Migration migration) {
        DataSource dataSource;
        Intrinsics.checkParameterIsNotNull((Object)migration, (String)"migration");
        DatabaseDriver databaseDriver = migration.getDriver();
        if (databaseDriver instanceof DatabaseDriver.MySql) {
            dataSource = this.buildMysqlDataSource(migration);
        } else if (databaseDriver instanceof DatabaseDriver.Postgres) {
            dataSource = this.buildPostgresDataSource(migration);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dataSource;
    }

    @NotNull
    public final DataSource addDatabaseNameToDataSource(@NotNull DataSource dataSource, @NotNull Migration migration) {
        DataSourceBuilder dataSourceBuilder;
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)migration, (String)"migration");
        Object object = migration.getDriver();
        if (object instanceof DatabaseDriver.MySql) {
            dataSourceBuilder = (DataSourceBuilder)this.mySqlBuilder.invoke((Object)dataSource);
        } else if (object instanceof DatabaseDriver.Postgres) {
            dataSourceBuilder = (DataSourceBuilder)this.postgresBuilder.invoke((Object)dataSource);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DataSourceBuilder builder = dataSourceBuilder;
        Object $receiver = object = builder;
        $receiver.setPassword(migration.getPassword());
        $receiver.setDatabaseName(migration.getSchema());
        return object.build();
    }

    private final DataSource buildMysqlDataSource(Migration migration) {
        Object object = this.mySqlBuilder.invoke(null);
        DataSourceBuilder $receiver = (DataSourceBuilder)object;
        $receiver.setUser(migration.getUser());
        $receiver.setHost(migration.getHost());
        String string = migration.getPort();
        DataSourceBuilder dataSourceBuilder = $receiver;
        int n = Integer.parseInt(string);
        dataSourceBuilder.setPort(n);
        $receiver.setPassword(migration.getPassword());
        return ((DataSourceBuilder)object).build();
    }

    private final DataSource buildPostgresDataSource(Migration migration) {
        Object object = this.postgresBuilder.invoke(null);
        DataSourceBuilder $receiver = (DataSourceBuilder)object;
        $receiver.setUser(migration.getUser());
        $receiver.setHost(migration.getHost());
        String string = migration.getPort();
        DataSourceBuilder dataSourceBuilder = $receiver;
        int n = Integer.parseInt(string);
        dataSourceBuilder.setPort(n);
        $receiver.setDatabaseName(migration.getSchema());
        $receiver.setPassword(migration.getPassword());
        return ((DataSourceBuilder)object).build();
    }

    public DataSourceFactory(@NotNull Function1<? super DataSource, ? extends DataSourceBuilder> mySqlBuilder, @NotNull Function1<? super DataSource, ? extends DataSourceBuilder> postgresBuilder) {
        Intrinsics.checkParameterIsNotNull(mySqlBuilder, (String)"mySqlBuilder");
        Intrinsics.checkParameterIsNotNull(postgresBuilder, (String)"postgresBuilder");
        this.mySqlBuilder = mySqlBuilder;
        this.postgresBuilder = postgresBuilder;
    }

    public /* synthetic */ DataSourceFactory(Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function12 = 2.INSTANCE;
        }
        this((Function1<? super DataSource, ? extends DataSourceBuilder>)function1, (Function1<? super DataSource, ? extends DataSourceBuilder>)function12);
    }

    public DataSourceFactory() {
        this(null, null, 3, null);
    }
}

