/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudfoundry.tools.pushapps.AsyncLoggerKt;
import org.cloudfoundry.tools.pushapps.DataSourceFactory;
import org.cloudfoundry.tools.pushapps.DatabaseMigrator$migrate$2;
import org.cloudfoundry.tools.pushapps.DatabaseMigratorKt$sam$Function$ca075564;
import org.cloudfoundry.tools.pushapps.FlywayWrapper;
import org.cloudfoundry.tools.pushapps.OperationResult;
import org.cloudfoundry.tools.pushapps.ScheduleOperationsKt;
import org.cloudfoundry.tools.pushapps.config.DatabaseDriver;
import org.cloudfoundry.tools.pushapps.config.Migration;
import org.cloudfoundry.tools.pushapps.config.OperationConfig;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/cloudfoundry/tools/pushapps/DatabaseMigrator;", "", "migrations", "", "Lorg/cloudfoundry/tools/pushapps/config/Migration;", "flywayWrapper", "Lorg/cloudfoundry/tools/pushapps/FlywayWrapper;", "dataSourceFactory", "Lorg/cloudfoundry/tools/pushapps/DataSourceFactory;", "maxInFlight", "", "timeoutInMinutes", "", "(Ljava/util/List;Lorg/cloudfoundry/tools/pushapps/FlywayWrapper;Lorg/cloudfoundry/tools/pushapps/DataSourceFactory;IJ)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "createDatabaseIfAbsent", "", "conn", "Ljava/sql/Connection;", "dbName", "", "migrate", "Lreactor/core/publisher/Flux;", "Lorg/cloudfoundry/tools/pushapps/OperationResult;", "migrateDatabase", "Lreactor/core/publisher/Mono;", "migration", "migrationDescription", "push-apps"})
public final class DatabaseMigrator {
    private final Logger logger;
    private final List<Migration> migrations;
    private final FlywayWrapper flywayWrapper;
    private final DataSourceFactory dataSourceFactory;
    private final int maxInFlight;
    private final long timeoutInMinutes;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flux<OperationResult> migrate() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.migrations;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            String string = ((Migration)receiver).getSchema();
            collection.add(string);
        }
        List schemas = (List)destination$iv$iv;
        this.logger.info("Running migrations for the following schemas: " + CollectionsKt.joinToString$default((Iterable)schemas, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        return ScheduleOperationsKt.scheduleOperations$default(this.migrations, this.maxInFlight, (Function1)new Function1<Migration, Mono<OperationResult>>(this){

            @NotNull
            public final Mono<OperationResult> invoke(@NotNull Migration p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return DatabaseMigrator.access$migrateDatabase((DatabaseMigrator)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(DatabaseMigrator.class);
            }

            public final String getName() {
                return "migrateDatabase";
            }

            public final String getSignature() {
                return "migrateDatabase(Lorg/cloudfoundry/tools/pushapps/config/Migration;)Lreactor/core/publisher/Mono;";
            }
        }, (Function1)DatabaseMigrator$migrate$2.INSTANCE, (Function1)new Function1<Migration, String>(this){

            @NotNull
            public final String invoke(@NotNull Migration p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return DatabaseMigrator.access$migrationDescription((DatabaseMigrator)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(DatabaseMigrator.class);
            }

            public final String getName() {
                return "migrationDescription";
            }

            public final String getSignature() {
                return "migrationDescription(Lorg/cloudfoundry/tools/pushapps/config/Migration;)Ljava/lang/String;";
            }
        }, null, 32, null);
    }

    private final String migrationDescription(Migration migration) {
        return "Migrating " + migration.getDriver().getName() + " schema " + migration.getSchema() + '.';
    }

    private final Mono<OperationResult> migrateDatabase(Migration migration) {
        DataSource dataSource = this.dataSourceFactory.buildDataSource(migration);
        if (migration.getDriver() instanceof DatabaseDriver.MySql) {
            Connection connection = dataSource.getConnection();
            Intrinsics.checkExpressionValueIsNotNull((Object)connection, (String)"dataSource.connection");
            this.createDatabaseIfAbsent(connection, migration.getSchema());
        }
        DataSource newDataSource = this.dataSourceFactory.addDatabaseNameToDataSource(dataSource, migration);
        String description = this.migrationDescription(migration);
        Function1 function1 = null;
        Throwable throwable = null;
        OperationConfig operationConfig = migration;
        boolean bl = true;
        OperationResult operationResult = new OperationResult(description, operationConfig, bl, throwable, (Flux)function1, 24, null);
        Mono mono = this.flywayWrapper.migrate(newDataSource, migration.getMigrationDir(), migration.getRepair()).timeout(Duration.ofMinutes(this.timeoutInMinutes));
        Logger logger = this.logger;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        Object object = AsyncLoggerKt.logAsyncOperation(logger, description);
        if (object != null) {
            function1 = object;
            object = new DatabaseMigratorKt$sam$Function$ca075564(function1);
        }
        Mono mono2 = mono.transform((Function)object).then(Mono.just((Object)operationResult));
        Intrinsics.checkExpressionValueIsNotNull((Object)mono2, (String)"flywayWrapper\n          \u2026no.just(operationResult))");
        return mono2;
    }

    private final void createDatabaseIfAbsent(Connection conn, String dbName) {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE DATABASE IF NOT EXISTS " + dbName + ';');
        }
        catch (SQLException ex) {
            this.logger.error("Unable to create database " + dbName + ". Caught exception: " + ex.getMessage());
        }
    }

    public DatabaseMigrator(@NotNull List<Migration> migrations, @NotNull FlywayWrapper flywayWrapper, @NotNull DataSourceFactory dataSourceFactory, int maxInFlight, long timeoutInMinutes) {
        Intrinsics.checkParameterIsNotNull(migrations, (String)"migrations");
        Intrinsics.checkParameterIsNotNull((Object)flywayWrapper, (String)"flywayWrapper");
        Intrinsics.checkParameterIsNotNull((Object)dataSourceFactory, (String)"dataSourceFactory");
        this.migrations = migrations;
        this.flywayWrapper = flywayWrapper;
        this.dataSourceFactory = dataSourceFactory;
        this.maxInFlight = maxInFlight;
        this.timeoutInMinutes = timeoutInMinutes;
        this.logger = LogManager.getLogger(DatabaseMigrator.class);
    }

    @NotNull
    public static final /* synthetic */ Mono access$migrateDatabase(DatabaseMigrator $this, @NotNull Migration migration) {
        return $this.migrateDatabase(migration);
    }

    @NotNull
    public static final /* synthetic */ String access$migrationDescription(DatabaseMigrator $this, @NotNull Migration migration) {
        return $this.migrationDescription(migration);
    }
}

