/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.gmavenplus.model.Version;
import org.codehaus.gmavenplus.util.ClassWrangler;

public abstract class AbstractGroovyMojo
extends AbstractMojo {
    protected static final String GROOVY_SOURCES_PATTERN = "**" + File.separator + "*.groovy";
    protected static final String JAVA_SOURCES_PATTERN = "**" + File.separator + "*.java";
    protected static final Version JAVA_1_7 = new Version(1, 7);
    protected static final Version JAVA_1_8 = new Version(1, 8);
    protected static final Version GROOVY_1_5_0 = new Version(1, 5, 0);
    protected ClassWrangler classWrangler;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Parameter(property="mojoExecution", required=true, readonly=true)
    protected MojoExecution mojoExecution;
    protected Version minGroovyVersion = GROOVY_1_5_0;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skipTests;

    protected void logPluginClasspath() {
        if (this.getLog().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Artifact artifact : this.pluginArtifacts) {
                sb.append(artifact.getFile());
            }
            this.getLog().debug((CharSequence)("Plugin classpath:\n" + sb.toString()));
        }
    }

    protected boolean isJavaSupportIndy() {
        return this.getJavaVersion().compareTo(JAVA_1_7, false) >= 0;
    }

    protected boolean isJavaSupportParameters() {
        return this.getJavaVersion().compareTo(JAVA_1_8, false) >= 0;
    }

    protected Version getJavaVersion() {
        return Version.parseFromString(this.getJavaVersionString());
    }

    protected String getJavaVersionString() {
        return System.getProperty("java.version");
    }

    protected boolean groovyVersionSupportsAction() {
        return this.classWrangler.getGroovyVersion() != null && this.groovyAtLeast(this.minGroovyVersion);
    }

    protected boolean groovyAtLeast(Version version) {
        return ClassWrangler.groovyAtLeast(this.classWrangler.getGroovyVersion(), version);
    }

    protected boolean groovyIs(Version version) {
        return ClassWrangler.groovyIs(this.classWrangler.getGroovyVersion(), version);
    }

    protected boolean groovyNewerThan(Version version) {
        return ClassWrangler.groovyNewerThan(this.classWrangler.getGroovyVersion(), version);
    }

    protected boolean groovyOlderThan(Version version) {
        return ClassWrangler.groovyOlderThan(this.classWrangler.getGroovyVersion(), version);
    }
}

