/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;

public class ClassNodeUtils {
    public static void addInterfaceMethods(ClassNode cnode, Map<String, MethodNode> methodsMap) {
        ClassNode[] classNodeArray = cnode.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode iface = classNodeArray[n2];
            Map<String, MethodNode> ifaceMethodsMap = iface.getDeclaredMethodsMap();
            for (Map.Entry<String, MethodNode> entry : ifaceMethodsMap.entrySet()) {
                if (!entry.getValue().getDeclaringClass().isInterface()) continue;
                methodsMap.putIfAbsent(entry.getKey(), entry.getValue());
            }
            ++n2;
        }
    }

    public static Map<String, MethodNode> getDeclaredMethodMapsFromInterfaces(ClassNode classNode) {
        HashMap<String, MethodNode> result = new HashMap<String, MethodNode>();
        ClassNodeUtils.addInterfaceMethods(classNode, result);
        return result;
    }

    public static void addDeclaredMethodMapsFromSuperInterfaces(ClassNode cn, Map<String, MethodNode> allInterfaceMethods) {
        List<ClassNode> cnInterfaces = Arrays.asList(cn.getInterfaces());
        ClassNode sn = cn.getSuperClass();
        while (sn != null && !sn.equals(ClassHelper.OBJECT_TYPE)) {
            ClassNode[] interfaces;
            ClassNode[] classNodeArray = interfaces = sn.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode iface = classNodeArray[n2];
                if (!cnInterfaces.contains(iface)) {
                    allInterfaceMethods.putAll(iface.getDeclaredMethodsMap());
                }
                ++n2;
            }
            sn = sn.getSuperClass();
        }
    }
}

