/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTAnnotationNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;

public class JDTMethodNode
extends MethodNode
implements JDTNode {
    private MethodBinding methodBinding;
    private JDTResolver resolver;
    private volatile int bits;

    public JDTMethodNode(MethodBinding methodBinding, JDTResolver resolver, String name, int modifiers, ClassNode returnType, Parameter[] parameters, ClassNode[] exceptions, Statement code) {
        super(name, modifiers, returnType, parameters, exceptions, code);
        this.methodBinding = methodBinding;
        this.resolver = resolver;
    }

    @Override
    public void addAnnotation(AnnotationNode value) {
        throw new IllegalStateException("JDTMethodNode is immutable");
    }

    @Override
    public void addAnnotations(List<AnnotationNode> annotations) {
        throw new IllegalStateException("JDTMethodNode is immutable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAnnotationsInitialized() {
        if ((this.bits & 1) == 0) {
            JDTMethodNode jDTMethodNode = this;
            synchronized (jDTMethodNode) {
                if ((this.bits & 1) == 0) {
                    AnnotationBinding[] annotationBindingArray = this.methodBinding.getAnnotations();
                    int n = annotationBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AnnotationBinding annotationBinding = annotationBindingArray[n2];
                        super.addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
                        ++n2;
                    }
                    this.bits |= 1;
                }
            }
        }
    }

    @Override
    public List<AnnotationNode> getAnnotations() {
        this.ensureAnnotationsInitialized();
        return Collections.unmodifiableList(super.getAnnotations());
    }

    @Override
    public List<AnnotationNode> getAnnotations(ClassNode type) {
        this.ensureAnnotationsInitialized();
        return super.getAnnotations(type);
    }

    @Override
    public Binding getJdtBinding() {
        return this.methodBinding;
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding;
    }

    @Override
    public JDTResolver getResolver() {
        return this.resolver;
    }

    @Override
    public boolean isDefault() {
        return this.methodBinding.isDefaultMethod();
    }

    @Override
    public boolean isDeprecated() {
        return this.methodBinding.isViewedAsDeprecated();
    }
}

