/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class ContentTypeBuilder {
    public static final String PT_CONTENTTYPES = "contentTypes";
    private ContentTypeCatalog catalog;
    private static final IConfigurationElement[] emptyConfArray = new IConfigurationElement[0];

    private static String getUniqueId(String namespace, String baseTypeId) {
        if (baseTypeId == null) {
            return null;
        }
        int separatorPosition = baseTypeId.lastIndexOf(46);
        if (separatorPosition == -1) {
            baseTypeId = String.valueOf(namespace) + '.' + baseTypeId;
        }
        return baseTypeId;
    }

    private static QualifiedName parseQualifiedName(String namespace, String value) {
        if (value == null) {
            return null;
        }
        int separatorPosition = value.lastIndexOf(46);
        if (separatorPosition == -1) {
            return new QualifiedName(namespace, value);
        }
        if (separatorPosition == 0 || separatorPosition == value.length() - 1) {
            return null;
        }
        namespace = value.substring(0, separatorPosition);
        String simpleValue = value.substring(separatorPosition + 1);
        return new QualifiedName(namespace, simpleValue);
    }

    private static byte parsePriority(String priority) {
        if (priority == null) {
            return 0;
        }
        if ("high".equals(priority)) {
            return 1;
        }
        if ("low".equals(priority)) {
            return -1;
        }
        if (!"normal".equals(priority)) {
            return 0;
        }
        return 0;
    }

    protected ContentTypeBuilder(ContentTypeCatalog catalog) {
        this.catalog = catalog;
    }

    private void addFileAssociation(IConfigurationElement fileAssociationElement, ContentType target) {
        String[] filePatterns;
        String[] fileExtensions;
        String[] fileNames;
        String[] stringArray = fileNames = Util.parseItems(fileAssociationElement.getAttribute("file-names"));
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            target.internalAddFileSpec(fileName, 5);
            ++n2;
        }
        String[] stringArray2 = fileExtensions = Util.parseItems(fileAssociationElement.getAttribute("file-extensions"));
        int n3 = fileExtensions.length;
        n = 0;
        while (n < n3) {
            String fileExtension = stringArray2[n];
            target.internalAddFileSpec(fileExtension, 9);
            ++n;
        }
        String[] stringArray3 = filePatterns = Util.parseItems(fileAssociationElement.getAttribute("file-patterns"));
        int n4 = filePatterns.length;
        n3 = 0;
        while (n3 < n4) {
            String filePattern = stringArray3[n3];
            target.internalAddFileSpec(filePattern, 17);
            ++n3;
        }
    }

    public void buildCatalog(IScopeContext context) {
        IConfigurationElement allContentTypeCE;
        IConfigurationElement[] allContentTypeCEs;
        Object[] objectArray = allContentTypeCEs = this.getConfigurationElements();
        int n = allContentTypeCEs.length;
        int n2 = 0;
        while (n2 < n) {
            allContentTypeCE = objectArray[n2];
            if ("content-type".equals(allContentTypeCE.getName())) {
                this.registerContentType(allContentTypeCE);
            }
            ++n2;
        }
        objectArray = ContentTypeManager.getUserDefinedContentTypeIds(context);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement id = objectArray[n2];
            IEclipsePreferences node = context.getNode((String)id);
            this.catalog.addContentType(ContentType.createContentType(this.catalog, (String)id, node.get("name", ""), (byte)0, new String[0], new String[0], new String[0], node.get("baseTypeId", null), null, Collections.emptyMap(), null));
            ++n2;
        }
        objectArray = allContentTypeCEs;
        n = allContentTypeCEs.length;
        n2 = 0;
        while (n2 < n) {
            allContentTypeCE = objectArray[n2];
            if ("file-association".equals(allContentTypeCE.getName())) {
                this.registerFileAssociation(allContentTypeCE);
            }
            ++n2;
        }
        this.applyPreferences();
    }

    private void applyPreferences() {
        try {
            ContentTypeCatalog localCatalog = this.catalog;
            IEclipsePreferences root = localCatalog.getManager().getPreferences();
            root.accept(node -> {
                if (node == root) {
                    return true;
                }
                ContentType contentType = localCatalog.internalGetContentType(node.name());
                if (contentType != null) {
                    contentType.processPreferences(node);
                }
                return false;
            });
        }
        catch (BackingStoreException bse) {
            ContentType.log(ContentMessages.content_errorLoadingSettings, bse);
        }
    }

    private ContentType createContentType(IConfigurationElement contentTypeCE) throws CoreException {
        String defaultCharset;
        String namespace = contentTypeCE.getContributor().getName();
        String simpleId = contentTypeCE.getAttribute("id");
        String name = contentTypeCE.getAttribute("name");
        if (simpleId == null) {
            this.missingMandatoryAttribute(ContentMessages.content_missingIdentifier, namespace);
        }
        String uniqueId = simpleId.lastIndexOf(46) == -1 ? String.valueOf(namespace) + '.' + simpleId : simpleId;
        if (name == null) {
            this.missingMandatoryAttribute(ContentMessages.content_missingName, uniqueId);
        }
        byte priority = ContentTypeBuilder.parsePriority(contentTypeCE.getAttribute("priority"));
        String[] fileNames = Util.parseItems(contentTypeCE.getAttribute("file-names"));
        String[] fileExtensions = Util.parseItems(contentTypeCE.getAttribute("file-extensions"));
        String[] filePatterns = Util.parseItems(contentTypeCE.getAttribute("file-patterns"));
        String baseTypeId = ContentTypeBuilder.getUniqueId(namespace, contentTypeCE.getAttribute("base-type"));
        String aliasTargetTypeId = ContentTypeBuilder.getUniqueId(namespace, contentTypeCE.getAttribute("alias-for"));
        IConfigurationElement[] propertyCEs = null;
        HashMap<QualifiedName, String> defaultProperties = null;
        propertyCEs = contentTypeCE.getChildren("property");
        if (propertyCEs.length > 0) {
            defaultProperties = new HashMap<QualifiedName, String>();
            IConfigurationElement[] iConfigurationElementArray = propertyCEs;
            int n = propertyCEs.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyKey;
                QualifiedName qualifiedKey;
                IConfigurationElement propertyCE = iConfigurationElementArray[n2];
                String defaultValue = propertyCE.getAttribute("default");
                if (defaultValue == null) {
                    defaultValue = "";
                }
                if ((qualifiedKey = ContentTypeBuilder.parseQualifiedName(namespace, propertyKey = propertyCE.getAttribute("name"))) == null) {
                    if (ContentTypeManager.DEBUGGING) {
                        String message = NLS.bind(ContentMessages.content_invalidProperty, propertyKey, ContentTypeBuilder.getUniqueId(namespace, simpleId));
                        ContentType.log(message, null);
                    }
                } else {
                    defaultProperties.put(qualifiedKey, defaultValue);
                }
                ++n2;
            }
        }
        if ((defaultCharset = contentTypeCE.getAttribute("default-charset")) != null) {
            if (defaultProperties == null) {
                defaultProperties = Collections.singletonMap(IContentDescription.CHARSET, defaultCharset);
            } else {
                defaultProperties.putIfAbsent(IContentDescription.CHARSET, defaultCharset);
            }
        }
        return ContentType.createContentType(this.catalog, uniqueId, name, priority, fileExtensions, fileNames, filePatterns, baseTypeId, aliasTargetTypeId, defaultProperties, contentTypeCE);
    }

    protected IConfigurationElement[] getConfigurationElements() {
        IExtensionPoint newPoint;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            return emptyConfArray;
        }
        IConfigurationElement[] oldConfigElements = emptyConfArray;
        IConfigurationElement[] newConfigElements = emptyConfArray;
        IExtensionPoint oldPoint = registry.getExtensionPoint("org.eclipse.core.runtime", PT_CONTENTTYPES);
        if (oldPoint != null) {
            oldConfigElements = oldPoint.getConfigurationElements();
        }
        if ((newPoint = registry.getExtensionPoint("org.eclipse.core.contenttype", PT_CONTENTTYPES)) != null) {
            newConfigElements = newPoint.getConfigurationElements();
        }
        IConfigurationElement[] allContentTypeCEs = new IConfigurationElement[oldConfigElements.length + newConfigElements.length];
        System.arraycopy(oldConfigElements, 0, allContentTypeCEs, 0, oldConfigElements.length);
        System.arraycopy(newConfigElements, 0, allContentTypeCEs, oldConfigElements.length, newConfigElements.length);
        return allContentTypeCEs;
    }

    private void missingMandatoryAttribute(String messageKey, String argument) throws CoreException {
        String message = NLS.bind(messageKey, argument);
        throw new CoreException(new Status(4, "org.eclipse.core.contenttype", 0, message, null));
    }

    private void registerContentType(IConfigurationElement contentTypeCE) {
        try {
            ContentType contentType = this.createContentType(contentTypeCE);
            this.catalog.addContentType(contentType);
        }
        catch (CoreException e) {
            RuntimeLog.log(e.getStatus());
        }
    }

    private void registerFileAssociation(IConfigurationElement fileAssociationElement) {
        String contentTypeId = ContentTypeBuilder.getUniqueId(fileAssociationElement.getContributor().getName(), fileAssociationElement.getAttribute("content-type"));
        ContentType target = this.catalog.internalGetContentType(contentTypeId);
        if (target == null) {
            return;
        }
        this.addFileAssociation(fileAssociationElement, target);
    }
}

