/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class CategoryTypeLookup
implements ITypeLookup {
    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        if (node instanceof VariableExpression || CategoryTypeLookup.isCompatibleConstantExpression(node, scope, objectExpressionType)) {
            String simpleName = node.getText();
            ClassNode selfType = GroovyUtils.getWrapperTypeIfPrimitive(objectExpressionType != null ? objectExpressionType : scope.getDelegateOrThis());
            boolean isMethodPointer = scope.getEnclosingNode() instanceof MethodPointerExpression;
            ArrayList<MethodNode> candidates = new ArrayList<MethodNode>();
            if (isMethodPointer || scope.isMethodCall()) {
                for (ClassNode category : scope.getCategoryNames()) {
                    for (MethodNode method : category.getMethods(simpleName)) {
                        if (!CategoryTypeLookup.isCompatibleCategoryMethod(method, selfType, scope)) continue;
                        candidates.add(method);
                    }
                }
            }
            if (!isMethodPointer) {
                AccessorSupport[] accessorSupportArray = AccessorSupport.values();
                int method = accessorSupportArray.length;
                int n = 0;
                while (n < method) {
                    AccessorSupport kind = accessorSupportArray[n];
                    String methodName = kind.createAccessorName(simpleName);
                    if (methodName != null) {
                        for (ClassNode category : scope.getCategoryNames()) {
                            for (MethodNode method2 : category.getMethods(methodName)) {
                                if (!kind.isAccessorKind(method2, true) || !CategoryTypeLookup.isCompatibleCategoryMethod(method2, selfType, scope) || kind == AccessorSupport.ISSER && !CategoryTypeLookup.isDefaultGroovyMethod(method2, scope) && !CategoryTypeLookup.isDefaultGroovyStaticMethod(method2, scope)) continue;
                                candidates.add(method2);
                            }
                        }
                    }
                    ++n;
                }
            }
            if (!candidates.isEmpty()) {
                MethodNode method;
                int args = 1 + scope.getMethodCallNumberOfArguments();
                ArrayList<ClassNode> argumentTypes = new ArrayList<ClassNode>(args);
                argumentTypes.add(selfType);
                if (args > 1) {
                    argumentTypes.addAll(scope.getMethodCallArgumentTypes());
                }
                if ((method = CategoryTypeLookup.selectBestMatch(candidates, argumentTypes, scope)) != null) {
                    TypeLookupResult result = new TypeLookupResult(method.getReturnType(), method.getDeclaringClass(), method, CategoryTypeLookup.isDefaultGroovyMethod(method, scope) ? TypeLookupResult.TypeConfidence.LOOSELY_INFERRED : TypeLookupResult.TypeConfidence.INFERRED, scope);
                    result.isGroovy = true;
                    return result;
                }
            }
        }
        return null;
    }

    protected static boolean isCompatibleConstantExpression(Expression node, VariableScope scope, ClassNode selfType) {
        ASTNode enclosingNode;
        if (!(!(node instanceof ConstantExpression) || scope.isTopLevel() || VariableScope.VOID_CLASS_NODE.equals(selfType) || (enclosingNode = scope.getEnclosingNode()) instanceof AttributeExpression || enclosingNode instanceof MethodPointerExpression && VariableScope.CLASS_CLASS_NODE.equals(selfType))) {
            return VariableScope.STRING_CLASS_NODE.equals(node.getType()) && node.getLength() <= node.getText().length();
        }
        return false;
    }

    protected static boolean isCompatibleCategoryMethod(MethodNode method, ClassNode firstArgumentType, VariableScope scope) {
        Parameter[] paramters;
        if (method.isStatic() && (paramters = method.getParameters()) != null && paramters.length > 0) {
            ClassNode parameterType = paramters[0].getType();
            if (VariableScope.CLASS_CLASS_NODE.equals(firstArgumentType) && CategoryTypeLookup.isDefaultGroovyStaticMethod(method, scope)) {
                parameterType = VariableScope.newClassClassNode(parameterType);
            }
            if (CategoryTypeLookup.isSelfTypeCompatible(firstArgumentType, parameterType)) {
                return !CategoryTypeLookup.isDefaultGroovyMethod(method, scope) || !GroovyUtils.isDeprecated(method);
            }
        }
        return false;
    }

    protected static boolean isSelfTypeCompatible(ClassNode source, ClassNode target) {
        if (SimpleTypeLookup.isTypeCompatible(source, target) != Boolean.FALSE) {
            ClassNode targetGT;
            if (!VariableScope.CLASS_CLASS_NODE.equals(source) || !source.isUsingGenerics() || VariableScope.OBJECT_CLASS_NODE.equals(target) || !target.isUsingGenerics()) {
                return true;
            }
            ClassNode sourceGT = source.getGenericsTypes()[0].getType();
            if (SimpleTypeLookup.isTypeCompatible(sourceGT, targetGT = target.getGenericsTypes()[0].getType()) != Boolean.FALSE) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isDefaultGroovyMethod(MethodNode method, VariableScope scope) {
        return VariableScope.DGM_CLASS_NODE.equals(method.getDeclaringClass()) || scope.isDefaultCategory(method.getDeclaringClass());
    }

    protected static boolean isDefaultGroovyStaticMethod(MethodNode method, VariableScope scope) {
        return VariableScope.DGSM_CLASS_NODE.equals(method.getDeclaringClass()) || scope.isDefaultStaticCategory(method.getDeclaringClass());
    }

    protected static MethodNode selectBestMatch(List<MethodNode> candidates, List<ClassNode> argumentTypes, VariableScope scope) {
        Function<MethodNode, List> argsWithSelfTypeFix = !VariableScope.CLASS_CLASS_NODE.equals(argumentTypes.get(0)) ? x -> argumentTypes : m -> {
            if (CategoryTypeLookup.isDefaultGroovyStaticMethod(m, scope)) {
                ArrayList<ClassNode> adjusted = new ArrayList<ClassNode>(argumentTypes);
                adjusted.set(0, ((ClassNode)argumentTypes.get(0)).getGenericsTypes()[0].getType());
                return adjusted;
            }
            return argumentTypes;
        };
        MethodNode method = null;
        for (MethodNode candidate : candidates) {
            long d2;
            long d1;
            if (argumentTypes.size() != candidate.getParameters().length) continue;
            Boolean compatible = SimpleTypeLookup.isTypeCompatible(argsWithSelfTypeFix.apply(candidate), candidate.getParameters());
            if (compatible == Boolean.TRUE) {
                method = candidate;
                break;
            }
            if (compatible == Boolean.FALSE || method != null && (d1 = CategoryTypeLookup.calculateParameterDistance(argsWithSelfTypeFix.apply(method), method.getParameters())) <= (d2 = CategoryTypeLookup.calculateParameterDistance(argsWithSelfTypeFix.apply(candidate), candidate.getParameters()))) continue;
            method = candidate;
        }
        return method;
    }

    protected static long calculateParameterDistance(List<ClassNode> arguments, Parameter[] parameters) {
        try {
            if (arguments.size() == 1 && parameters.length == 1) {
                Class[] args = new Class[]{arguments.get(0).getTypeClass()};
                Class[] prms = new Class[]{parameters[0].getType().getTypeClass()};
                return MetaClassHelper.calculateParameterDistance(args, new ParameterTypes(prms));
            }
            int n = 1 + arguments.size();
            Class[] args = new Class[n];
            int i = 1;
            while (i < n) {
                args[i] = arguments.get(i - 1).getTypeClass();
                ++i;
            }
            args[0] = args[1];
            n = 1 + parameters.length;
            Class[] prms = new Class[n];
            int i2 = 1;
            while (i2 < n) {
                prms[i2] = parameters[i2 - 1].getType().getTypeClass();
                ++i2;
            }
            prms[0] = prms[1];
            return MetaClassHelper.calculateParameterDistance(args, new ParameterTypes(prms));
        }
        catch (Throwable t) {
            return Long.MAX_VALUE - (long)(VariableScope.isVoidOrObject(parameters[0].getType()) ? 0 : 1);
        }
    }
}

