/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class CategoryTypeLookup
implements ITypeLookup {
    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        if (node instanceof VariableExpression || CategoryTypeLookup.isCompatibleConstantExpression(node, scope, objectExpressionType)) {
            String simpleName = node.getText();
            ClassNode selfType = GroovyUtils.getWrapperTypeIfPrimitive(objectExpressionType != null ? objectExpressionType : scope.getDelegateOrThis());
            boolean isMethodPointer = scope.getEnclosingNode() instanceof MethodPointerExpression;
            ArrayList<MethodNode> candidates = new ArrayList<MethodNode>();
            for (ClassNode category : scope.getCategoryNames()) {
                String setterName;
                String getterName;
                if (scope.isMethodCall() || isMethodPointer) {
                    for (MethodNode method : category.getMethods(simpleName)) {
                        if (!CategoryTypeLookup.isCompatibleCategoryMethod(method, selfType, scope)) continue;
                        candidates.add(method);
                    }
                }
                if ((getterName = AccessorSupport.GETTER.createAccessorName(simpleName)) != null && !isMethodPointer) {
                    for (MethodNode method : category.getMethods(getterName)) {
                        if (AccessorSupport.findAccessorKind(method, true) != AccessorSupport.GETTER || !CategoryTypeLookup.isCompatibleCategoryMethod(method, selfType, scope)) continue;
                        candidates.add(method);
                    }
                }
                if ((setterName = AccessorSupport.SETTER.createAccessorName(simpleName)) == null || isMethodPointer) continue;
                for (MethodNode method : category.getMethods(setterName)) {
                    if (AccessorSupport.findAccessorKind(method, true) != AccessorSupport.SETTER || !CategoryTypeLookup.isCompatibleCategoryMethod(method, selfType, scope)) continue;
                    candidates.add(method);
                }
            }
            if (!candidates.isEmpty()) {
                MethodNode method;
                int args = 1 + scope.getMethodCallNumberOfArguments();
                ArrayList<ClassNode> argumentTypes = new ArrayList<ClassNode>(args);
                argumentTypes.add(selfType);
                if (args > 1) {
                    argumentTypes.addAll(scope.getMethodCallArgumentTypes());
                }
                method = CategoryTypeLookup.selectBestMatch(candidates, argumentTypes);
                TypeLookupResult result = new TypeLookupResult(method.getReturnType(), method.getDeclaringClass(), method, CategoryTypeLookup.isDefaultGroovyMethod(method, scope) ? TypeLookupResult.TypeConfidence.LOOSELY_INFERRED : TypeLookupResult.TypeConfidence.INFERRED, scope);
                result.isGroovy = true;
                return result;
            }
        }
        return null;
    }

    protected static boolean isCompatibleConstantExpression(Expression node, VariableScope scope, ClassNode selfType) {
        ASTNode enclosingNode;
        if (!(!(node instanceof ConstantExpression) || scope.isTopLevel() || (enclosingNode = scope.getEnclosingNode()) instanceof AttributeExpression || enclosingNode instanceof MethodPointerExpression && VariableScope.CLASS_CLASS_NODE.equals(selfType))) {
            return VariableScope.STRING_CLASS_NODE.equals(node.getType()) && node.getLength() <= node.getText().length();
        }
        return false;
    }

    protected static boolean isCompatibleCategoryMethod(MethodNode method, ClassNode firstArgumentType, VariableScope scope) {
        Parameter[] paramters;
        if (method.isStatic() && (paramters = method.getParameters()) != null && paramters.length > 0) {
            ClassNode parameterType = paramters[0].getType();
            if (VariableScope.CLASS_CLASS_NODE.equals(firstArgumentType) && CategoryTypeLookup.isDefaultGroovyStaticMethod(method, scope)) {
                parameterType = VariableScope.newClassClassNode(parameterType);
            }
            if (CategoryTypeLookup.isTypeCompatible(firstArgumentType, parameterType)) {
                return !CategoryTypeLookup.isDefaultGroovyMethod(method, scope) || !GroovyUtils.isDeprecated(method);
            }
        }
        return false;
    }

    protected static boolean isTypeCompatible(ClassNode source, ClassNode target) {
        if (SimpleTypeLookup.isTypeCompatible(source, target) != Boolean.FALSE) {
            if (!VariableScope.CLASS_CLASS_NODE.equals(source) || !source.isUsingGenerics() || VariableScope.OBJECT_CLASS_NODE.equals(target) || !target.isUsingGenerics()) {
                return true;
            }
            if (SimpleTypeLookup.isTypeCompatible(source = source.getGenericsTypes()[0].getType(), target = target.getGenericsTypes()[0].getType()) != Boolean.FALSE) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isDefaultGroovyMethod(MethodNode method, VariableScope scope) {
        return VariableScope.DGM_CLASS_NODE.equals(method.getDeclaringClass()) || scope.isDefaultCategory(method.getDeclaringClass());
    }

    protected static boolean isDefaultGroovyStaticMethod(MethodNode method, VariableScope scope) {
        return VariableScope.DGSM_CLASS_NODE.equals(method.getDeclaringClass()) || scope.isDefaultStaticCategory(method.getDeclaringClass());
    }

    protected static MethodNode selectBestMatch(List<MethodNode> candidates, List<ClassNode> argumentTypes) {
        MethodNode method = null;
        for (MethodNode candidate : candidates) {
            if (argumentTypes.size() != candidate.getParameters().length) continue;
            Boolean compatible = SimpleTypeLookup.isTypeCompatible(argumentTypes, candidate.getParameters());
            if (compatible == Boolean.TRUE) {
                method = candidate;
                break;
            }
            if (compatible != Boolean.FALSE) {
                long d2;
                long d1;
                if (method != null && (d1 = CategoryTypeLookup.calculateParameterDistance(argumentTypes, method.getParameters())) <= (d2 = CategoryTypeLookup.calculateParameterDistance(argumentTypes, candidate.getParameters()))) continue;
                method = candidate;
                continue;
            }
            if (method != null) continue;
            method = candidate;
        }
        return method != null ? method : candidates.get(0);
    }

    protected static long calculateParameterDistance(List<ClassNode> arguments, Parameter[] parameters) {
        try {
            int n = 1 + arguments.size();
            Class[] args = new Class[n];
            int i = 1;
            while (i < n) {
                args[i] = arguments.get(i - 1).getTypeClass();
                ++i;
            }
            args[0] = args[1];
            n = 1 + parameters.length;
            Class[] prms = new Class[n];
            int i2 = 1;
            while (i2 < n) {
                prms[i2] = parameters[i2 - 1].getType().getTypeClass();
                ++i2;
            }
            prms[0] = prms[1];
            return MetaClassHelper.calculateParameterDistance(args, new ParameterTypes(prms));
        }
        catch (Throwable t) {
            return Long.MAX_VALUE - (long)(VariableScope.isVoidOrObject(parameters[0].getType()) ? 0 : 1);
        }
    }
}

