/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class LocalVariableReferenceRequestor
implements ITypeRequestor {
    private final List<IRegion> references = new ArrayList<IRegion>();
    private Variable variable;
    private String variableName;
    private IJavaElement enclosingElement;
    private boolean foundEnclosingElement;
    private int declStart;
    private SearchRequestor requestor;
    private SearchParticipant participant;

    public LocalVariableReferenceRequestor(Variable variable, IJavaElement enclosingElement) {
        this(variable.getName(), enclosingElement, null, null, -1);
        this.variable = variable;
    }

    public LocalVariableReferenceRequestor(String variableName, IJavaElement enclosingElement, SearchRequestor requestor, SearchParticipant participant, int declStart) {
        this.variableName = variableName;
        this.enclosingElement = enclosingElement;
        this.declStart = declStart;
        this.requestor = requestor;
        this.participant = participant;
    }

    public List<IRegion> getReferences() {
        return this.references;
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (enclosingElement.equals(this.enclosingElement)) {
            this.foundEnclosingElement = true;
            if (node instanceof Variable && this.isMatchForVariable((Variable)((Object)node))) {
                IRegion realSourceLocation = this.getRealSourceLocation(node);
                this.references.add(realSourceLocation);
                if (this.requestor != null && realSourceLocation.getOffset() >= this.declStart) {
                    try {
                        this.requestor.acceptSearchMatch(new LocalVariableReferenceMatch(enclosingElement, 0, realSourceLocation.getOffset(), realSourceLocation.getLength(), true, true, false, this.participant, enclosingElement.getResource()));
                    }
                    catch (CoreException e) {
                        Util.log(e);
                    }
                }
            }
        } else if (this.foundEnclosingElement) {
            return ITypeRequestor.VisitStatus.STOP_VISIT;
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private IRegion getRealSourceLocation(ASTNode node) {
        if (node instanceof Parameter) {
            Parameter parameter = (Parameter)node;
            return new Region(parameter.getNameStart(), parameter.getNameEnd() - parameter.getNameStart());
        }
        return new Region(node.getStart(), this.variableName.length());
    }

    private boolean isMatchForVariable(Variable var) {
        if (this.variable != null) {
            if (var instanceof VariableExpression) {
                return ((VariableExpression)var).getAccessedVariable() == this.variable;
            }
            return var == this.variable;
        }
        return var.getName().equals(this.variableName);
    }
}

