/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovy.lang.Writable;
import groovy.xml.StreamingMarkupBuilder;
import groovyx.net.http.ContentType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonGroovyBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.groovy.runtime.MethodClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncoderRegistry {
    Charset charset = Charset.defaultCharset();
    protected Map<String, Closure> registeredEncoders = this.buildDefaultEncoderMap();

    public void setCharset(String charset) {
        this.charset = Charset.forName(charset);
    }

    public InputStreamEntity encodeStream(Object data) throws UnsupportedEncodingException {
        if (data instanceof InputStream) {
            return new InputStreamEntity((InputStream)data, -1L);
        }
        if (data instanceof ByteArrayInputStream) {
            ByteArrayInputStream in = (ByteArrayInputStream)data;
            return new InputStreamEntity((InputStream)in, (long)in.available());
        }
        if (data instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream out = (ByteArrayOutputStream)data;
            return new InputStreamEntity((InputStream)new ByteArrayInputStream(out.toByteArray()), (long)out.size());
        }
        if (data instanceof Closure) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ((Closure)data).call((Object)out);
            return new InputStreamEntity((InputStream)new ByteArrayInputStream(out.toByteArray()), (long)out.size());
        }
        throw new IllegalArgumentException("Don't know how to encode " + data + " as a byte stream");
    }

    public HttpEntity encodeText(Object data) throws IOException {
        StringWriter out;
        if (data instanceof Closure) {
            out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            ((Closure)data).call((Object)writer);
            writer.close();
            out.flush();
            data = out;
        } else if (data instanceof Writable) {
            out = new StringWriter();
            ((Writable)data).writeTo((Writer)out);
            out.flush();
            data = out;
        } else if (data instanceof Reader && !(data instanceof BufferedReader)) {
            data = new BufferedReader((Reader)data);
        }
        if (data instanceof BufferedReader) {
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = (BufferedReader)data;
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            data = sb;
        }
        return this.createEntity(ContentType.TEXT, data.toString());
    }

    public UrlEncodedFormEntity encodeForm(Map<String, Object> params) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramList.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        return new UrlEncodedFormEntity(paramList, this.charset.name());
    }

    public HttpEntity encodeXML(Closure xmlBuilder) throws UnsupportedEncodingException {
        StreamingMarkupBuilder smb = new StreamingMarkupBuilder();
        String markup = smb.bind((Object)xmlBuilder).toString();
        return this.createEntity(ContentType.XML, markup);
    }

    public HttpEntity encodeJSON(Object model) throws UnsupportedEncodingException {
        JSONObject json;
        if (model instanceof Map) {
            json = new JSONObject();
            json.putAll((Map)model);
        } else if (model instanceof Closure) {
            Closure closure = (Closure)model;
            closure.setDelegate((Object)new JsonGroovyBuilder());
            json = (JSONObject)closure.call();
        } else {
            json = JSONObject.fromObject((Object)model);
        }
        return this.createEntity(ContentType.JSON, json.toString());
    }

    protected StringEntity createEntity(ContentType ct, String data) throws UnsupportedEncodingException {
        StringEntity entity = new StringEntity(data, this.charset.toString());
        entity.setContentType(ct.toString());
        return entity;
    }

    public void register(String contentType, Closure closure) {
        this.registeredEncoders.put(contentType, closure);
    }

    Closure get(String contentType) {
        return this.registeredEncoders.get(contentType);
    }

    protected Map<String, Closure> buildDefaultEncoderMap() {
        HashMap<String, Closure> encoders = new HashMap<String, Closure>();
        encoders.put(ContentType.BINARY.toString(), (Closure)new MethodClosure((Object)this, "encodeStream"));
        encoders.put(ContentType.TEXT.toString(), (Closure)new MethodClosure((Object)this, "encodeText"));
        encoders.put(ContentType.URLENC.toString(), (Closure)new MethodClosure((Object)this, "encodeForm"));
        MethodClosure encClosure = new MethodClosure((Object)this, "encodeXML");
        for (String ct : ContentType.XML.getContentTypeStrings()) {
            encoders.put(ct, (Closure)encClosure);
        }
        encoders.put(ContentType.HTML.toString(), (Closure)encClosure);
        encClosure = new MethodClosure((Object)this, "encodeJSON");
        for (String ct : ContentType.JSON.getContentTypeStrings()) {
            encoders.put(ct, (Closure)encClosure);
        }
        return encoders;
    }
}

