/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovyx.net.http.AuthConfig;
import groovyx.net.http.ContentEncoding;
import groovyx.net.http.ContentEncodingRegistry;
import groovyx.net.http.ContentType;
import groovyx.net.http.EncoderRegistry;
import groovyx.net.http.Method;
import groovyx.net.http.ParserRegistry;
import groovyx.net.http.Status;
import groovyx.net.http.URIBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MethodClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPBuilder {
    protected AbstractHttpClient client;
    protected URI defaultURI = null;
    protected AuthConfig auth = new AuthConfig(this);
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Object defaultContentType = ContentType.ANY;
    protected final Map<String, Closure> defaultResponseHandlers = this.buildDefaultResponseHandlers();
    protected ContentEncodingRegistry contentEncodingHandler = new ContentEncodingRegistry();
    protected final Map<String, String> defaultRequestHeaders = new HashMap<String, String>();
    protected EncoderRegistry encoders = new EncoderRegistry();
    protected ParserRegistry parsers = new ParserRegistry();

    public HTTPBuilder() {
        this.client = new DefaultHttpClient();
        this.setContentEncoding(new Object[]{ContentEncoding.Type.GZIP, ContentEncoding.Type.DEFLATE});
    }

    public HTTPBuilder(Object defaultURL) throws URISyntaxException {
        this();
        this.defaultURI = URIBuilder.convertToURI(defaultURL);
    }

    public HTTPBuilder(Object defaultURL, Object defaultContentType) throws URISyntaxException {
        this();
        this.defaultURI = URIBuilder.convertToURI(defaultURL);
        this.defaultContentType = defaultContentType;
    }

    public Object get(Map<String, ?> args) throws ClientProtocolException, IOException, URISyntaxException {
        return this.get(args, null);
    }

    public Object get(Map<String, ?> args, Closure responseClosure) throws ClientProtocolException, IOException, URISyntaxException {
        SendDelegate delegate = new SendDelegate((HttpRequestBase)new HttpGet(), this.defaultContentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        delegate.setPropertiesFromMap(args);
        if (responseClosure != null) {
            delegate.getResponse().put(Status.SUCCESS.toString(), responseClosure);
        }
        return this.doRequest(delegate);
    }

    public Object post(Map<String, ?> args) throws ClientProtocolException, URISyntaxException, IOException {
        return this.post(args, null);
    }

    public Object post(Map<String, ?> args, Closure responseClosure) throws URISyntaxException, ClientProtocolException, IOException {
        SendDelegate delegate = new SendDelegate((HttpRequestBase)new HttpPost(), this.defaultContentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        delegate.setRequestContentType(ContentType.URLENC.toString());
        delegate.setPropertiesFromMap(args);
        if (responseClosure != null) {
            delegate.getResponse().put(Status.SUCCESS.toString(), responseClosure);
        }
        return this.doRequest(delegate);
    }

    public Object request(Method m, Closure configClosure) throws ClientProtocolException, IOException {
        return this.doRequest(this.defaultURI, m, this.defaultContentType, configClosure);
    }

    public Object request(Method m, Object contentType, Closure configClosure) throws ClientProtocolException, IOException {
        return this.doRequest(this.defaultURI, m, contentType, configClosure);
    }

    public Object request(Object uri, Method method, Object contentType, Closure configClosure) throws ClientProtocolException, IOException, URISyntaxException {
        return this.doRequest(URIBuilder.convertToURI(uri), method, contentType, configClosure);
    }

    protected Object doRequest(URI uri, Method method, Object contentType, Closure configClosure) throws ClientProtocolException, IOException {
        HttpRequestBase reqMethod;
        try {
            reqMethod = method.getRequestType().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        reqMethod.setURI(uri);
        SendDelegate delegate = new SendDelegate(reqMethod, contentType, this.defaultRequestHeaders, this.defaultResponseHandlers);
        configClosure.setDelegate((Object)delegate);
        configClosure.call((Object)this.client);
        return this.doRequest(delegate);
    }

    protected Object doRequest(SendDelegate delegate) throws ClientProtocolException, IOException {
        HttpRequestBase reqMethod = delegate.getRequest();
        Object contentType = delegate.getContentType();
        String acceptContentTypes = contentType.toString();
        if (contentType instanceof ContentType) {
            acceptContentTypes = ((ContentType)((Object)contentType)).getAcceptHeader();
        }
        reqMethod.setHeader("Accept", acceptContentTypes);
        reqMethod.setURI(delegate.getURL().toURI());
        Map<String, String> headers = delegate.getHeaders();
        for (String key : headers.keySet()) {
            String val = headers.get(key);
            if (val == null) {
                reqMethod.removeHeaders(key);
                continue;
            }
            reqMethod.setHeader(key, val);
        }
        HttpResponse resp = this.client.execute((HttpUriRequest)reqMethod);
        int status = resp.getStatusLine().getStatusCode();
        Closure responseClosure = delegate.findResponseHandler(status);
        this.log.debug((Object)("Response code: " + status + "; found handler: " + responseClosure));
        Object[] closureArgs = null;
        switch (responseClosure.getMaximumNumberOfParameters()) {
            case 1: {
                closureArgs = new Object[]{resp};
                break;
            }
            case 2: {
                Object parsedData;
                if (resp.getEntity() == null) {
                    this.log.warn((Object)"Response contains no entity, but response closure expects parsed data.  Passing null as second closure arg.");
                    closureArgs = new Object[]{resp, null};
                    break;
                }
                String responseContentType = contentType.toString();
                if (ContentType.ANY.toString().equals(responseContentType)) {
                    responseContentType = ParserRegistry.getContentType(resp);
                }
                if ((parsedData = this.parsers.get(responseContentType).call((Object)resp)) == null) {
                    this.log.warn((Object)"Parsed data is null!!!");
                } else {
                    this.log.debug((Object)("Parsed data from content-type '" + responseContentType + "' to object: " + parsedData.getClass()));
                }
                closureArgs = new Object[]{resp, parsedData};
                break;
            }
            default: {
                throw new IllegalArgumentException("Response closure must accept one or two parameters");
            }
        }
        Object returnVal = responseClosure.call(closureArgs);
        this.log.debug((Object)("response handler result: " + returnVal));
        HttpEntity responseContent = resp.getEntity();
        if (responseContent != null && responseContent.isStreaming()) {
            responseContent.consumeContent();
        }
        return returnVal;
    }

    protected Map<String, Closure> buildDefaultResponseHandlers() {
        HashMap<String, Closure> map = new HashMap<String, Closure>();
        map.put(Status.SUCCESS.toString(), (Closure)new MethodClosure((Object)this, "defaultSuccessHandler"));
        map.put(Status.FAILURE.toString(), (Closure)new MethodClosure((Object)this, "defaultFailureHandler"));
        return map;
    }

    protected Object defaultSuccessHandler(HttpResponse resp, Object parsedData) throws IOException {
        if (parsedData instanceof InputStream) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DefaultGroovyMethods.leftShift((OutputStream)buffer, (InputStream)((InputStream)parsedData));
            parsedData = new ByteArrayInputStream(buffer.toByteArray());
        } else if (parsedData instanceof Reader) {
            StringWriter buffer = new StringWriter();
            DefaultGroovyMethods.leftShift((Writer)buffer, (Object)((Reader)parsedData));
            parsedData = new StringReader(buffer.toString());
        } else if (parsedData instanceof Closeable) {
            this.log.warn((Object)"Parsed data is streaming, but will be accessible after the network connection is closed.  Use at your own risk!");
        }
        return parsedData;
    }

    protected void defaultFailureHandler(HttpResponse resp) throws HttpResponseException {
        throw new HttpResponseException(resp.getStatusLine().getStatusCode(), resp.getStatusLine().getReasonPhrase());
    }

    public Map<String, Closure> getHandler() {
        return this.defaultResponseHandlers;
    }

    public Map<String, Closure> getParser() {
        return this.parsers.registeredParsers;
    }

    public Map<String, Closure> getEncoder() {
        return this.encoders.registeredEncoders;
    }

    public void setContentType(Object ct) {
        this.defaultContentType = ct;
    }

    public void setContentEncoding(Object ... encodings) {
        this.contentEncodingHandler.setInterceptors(this.client, encodings);
    }

    public void setURL(Object url) throws URISyntaxException {
        this.defaultURI = URIBuilder.convertToURI(url);
    }

    public Object getURL() {
        try {
            return this.defaultURI.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHeaders(Map<?, ?> headers) {
        this.defaultRequestHeaders.clear();
        if (headers == null) {
            return;
        }
        for (Object key : headers.keySet()) {
            Object val = headers.get(key);
            if (val == null) continue;
            this.defaultRequestHeaders.put(key.toString(), val.toString());
        }
    }

    public Map<String, String> getHeaders() {
        return this.defaultRequestHeaders;
    }

    public AbstractHttpClient getClient() {
        return this.client;
    }

    public AuthConfig getAuth() {
        return this.auth;
    }

    public void setAuthConfig(AuthConfig ac) {
        this.auth = ac;
    }

    public void setEncoderRegistry(EncoderRegistry er) {
        this.encoders = er;
    }

    public void setParserRegistry(ParserRegistry pr) {
        this.parsers = pr;
    }

    public void setContentEncodingRegistry(ContentEncodingRegistry cer) {
        this.contentEncodingHandler = cer;
    }

    public void setProxy(String host, int port, String scheme) {
        this.getClient().getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(host, port, scheme));
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SendDelegate {
        protected HttpRequestBase request;
        protected Object contentType;
        protected String requestContentType;
        protected Map<String, Closure> responseHandlers = new HashMap<String, Closure>();
        protected URIBuilder url;
        protected Map<String, String> headers = new HashMap<String, String>();

        public SendDelegate(HttpRequestBase request, Object contentType, Map<String, String> defaultRequestHeaders, Map<String, Closure> defaultResponseHandlers) {
            this.request = request;
            this.headers.putAll(defaultRequestHeaders);
            this.contentType = contentType;
            this.responseHandlers.putAll(defaultResponseHandlers);
            this.url = new URIBuilder(request.getURI());
        }

        public URIBuilder getURL() {
            return this.url;
        }

        protected HttpRequestBase getRequest() {
            return this.request;
        }

        protected Object getContentType() {
            return this.contentType;
        }

        protected void setContentType(Object ct) {
            if (ct == null) {
                this.contentType = HTTPBuilder.this.defaultContentType;
            }
            this.contentType = ct;
        }

        protected String getRequestContentType() {
            if (this.requestContentType != null) {
                return this.requestContentType;
            }
            return this.getContentType().toString();
        }

        protected void setRequestContentType(String ct) {
            this.requestContentType = ct;
        }

        protected void setPropertiesFromMap(Map<String, ?> args) throws MalformedURLException, URISyntaxException {
            Object body;
            Object contentType;
            Object path;
            Map headers;
            Object uri = args.get("url");
            if (uri == null) {
                uri = HTTPBuilder.this.defaultURI;
            }
            this.url = new URIBuilder(URIBuilder.convertToURI(uri));
            Map params = (Map)args.get("params");
            if (params != null) {
                this.url.setQuery(params);
            }
            if ((headers = (Map)args.get("headers")) != null) {
                this.getHeaders().putAll(headers);
            }
            if ((path = args.get("path")) != null) {
                this.url.setPath(path.toString());
            }
            if ((contentType = args.get("contentType")) != null) {
                this.setContentType(contentType);
            }
            if ((contentType = args.get("requestContentType")) != null) {
                this.setRequestContentType(contentType.toString());
            }
            if ((body = args.get("body")) != null) {
                this.setBody(body);
            }
        }

        public void setHeaders(Map<?, ?> newHeaders) {
            for (Object key : newHeaders.keySet()) {
                Object val = newHeaders.get(key);
                if (val == null) {
                    this.headers.remove(key);
                    continue;
                }
                this.headers.put(key.toString(), val.toString());
            }
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void send(Object contentType, Object requestBody) {
            this.setRequestContentType(contentType.toString());
            this.setBody(requestBody);
        }

        public void setBody(Object body) {
            if (!(this.request instanceof HttpEntityEnclosingRequest)) {
                throw new UnsupportedOperationException("Cannot set a request body for a " + this.request.getMethod() + " method");
            }
            Closure encoder = HTTPBuilder.this.encoders.get(this.getRequestContentType());
            HttpEntity entity = (HttpEntity)encoder.call(body);
            ((HttpEntityEnclosingRequest)this.request).setEntity(entity);
        }

        protected Closure findResponseHandler(int statusCode) {
            Closure handler = this.getResponse().get(Integer.toString(statusCode));
            if (handler == null) {
                handler = this.getResponse().get(Status.find(statusCode).toString());
            }
            return handler;
        }

        public Map<String, Closure> getResponse() {
            return this.responseHandlers;
        }
    }
}

