/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.Classpath;
import org.codehaus.mojo.exec.EnvStreamConsumer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="exec", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ExecMojo
extends AbstractExecMojo {
    @Parameter(property="exec.executable", required=true)
    private String executable;
    @Parameter(property="exec.workingdir")
    private File workingDirectory;
    @Parameter(property="exec.outputFile")
    private File outputFile;
    @Parameter
    private List<?> arguments;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}")
    private File basedir;
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter
    private File environmentScript = null;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter
    private int[] successCodes;
    @Parameter(property="exec.longClasspath", defaultValue="false")
    private boolean longClasspath;
    public static final String CLASSPATH_TOKEN = "%classpath";
    private final String[] WINDOWS_SPECIAL_EXTS = new String[]{".bat", ".cmd"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skipping execute as per configuraion");
            return;
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        try {
            this.handleWorkingDirectory();
            String argsProp = this.getSystemProperty("exec.args");
            ArrayList<String> commandArguments = new ArrayList<String>();
            if (this.hasCommandlineArgs()) {
                this.handleCommandLineArgs(commandArguments);
            } else if (!StringUtils.isEmpty((String)argsProp)) {
                this.handleSystemPropertyArguments(argsProp, commandArguments);
            } else if (this.arguments != null) {
                this.handleArguments(commandArguments);
            }
            Map<String, String> enviro = this.handleSystemEnvVariables();
            CommandLine commandLine = this.getExecutablePath(enviro, this.workingDirectory);
            String[] args = commandArguments.toArray(new String[commandArguments.size()]);
            commandLine.addArguments(args, false);
            DefaultExecutor exec = new DefaultExecutor();
            exec.setWorkingDirectory(this.workingDirectory);
            this.fillSuccessCodes((Executor)exec);
            this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
            try {
                int resultCode;
                block17: {
                    block16: {
                        if (this.outputFile == null) break block16;
                        if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                            this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                        }
                        FileOutputStream outputStream = null;
                        try {
                            outputStream = new FileOutputStream(this.outputFile);
                            resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, outputStream);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(outputStream);
                            throw throwable;
                        }
                        IOUtil.close((OutputStream)outputStream);
                        break block17;
                    }
                    resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, System.out, System.err);
                }
                if (this.isResultCodeAFailure(resultCode)) {
                    throw new MojoExecutionException("Result of " + commandLine + " execution is: '" + resultCode + "'.");
                }
            }
            catch (ExecuteException e) {
                throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Command execution failed.", (Exception)e);
            }
            this.registerSourceRoots();
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O Error", (Exception)e);
        }
    }

    private Map<String, String> handleSystemEnvVariables() throws MojoExecutionException {
        HashMap<String, String> enviro = new HashMap<String, String>();
        try {
            Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
            for (Map.Entry<Object, Object> entry : systemEnvVars.entrySet()) {
                enviro.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException x) {
            this.getLog().error((CharSequence)"Could not assign default system enviroment variables.", (Throwable)x);
        }
        if (this.environmentVariables != null) {
            enviro.putAll(this.environmentVariables);
        }
        if (this.environmentScript != null) {
            this.getLog().info((CharSequence)("Pick up external environment script: " + this.environmentScript));
            Map<String, String> envVarsFromScript = this.createEnvs(this.environmentScript);
            if (envVarsFromScript != null) {
                enviro.putAll(envVarsFromScript);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            TreeSet keys = new TreeSet();
            keys.addAll(enviro.keySet());
            for (String key : keys) {
                this.getLog().debug((CharSequence)("env: " + key + "=" + (String)enviro.get(key)));
            }
        }
        return enviro;
    }

    private void handleWorkingDirectory() throws MojoExecutionException {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.basedir;
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().debug((CharSequence)("Making working directory '" + this.workingDirectory.getAbsolutePath() + "'."));
            if (!this.workingDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not make working directory: '" + this.workingDirectory.getAbsolutePath() + "'");
            }
        }
    }

    private void handleSystemPropertyArguments(String argsProp, List<String> commandArguments) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("got arguments from system properties: " + argsProp));
        try {
            String[] args = CommandLineUtils.translateCommandline((String)argsProp);
            commandArguments.addAll(Arrays.asList(args));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't parse systemproperty 'exec.args'");
        }
    }

    private void handleCommandLineArgs(List<String> commandArguments) throws MojoExecutionException, IOException {
        String[] args = this.parseCommandlineArgs();
        for (int i = 0; i < args.length; ++i) {
            if (this.isLongClassPathArgument(args[i])) {
                commandArguments.add("-jar");
                File tmpFile = this.createJar(this.computeClasspath(null), args[i + 2]);
                commandArguments.add(tmpFile.getAbsolutePath());
                i += 2;
                continue;
            }
            if (args[i].contains(CLASSPATH_TOKEN)) {
                commandArguments.add(args[i].replace(CLASSPATH_TOKEN, this.computeClasspathString(null)));
                continue;
            }
            commandArguments.add(args[i]);
        }
    }

    private void handleArguments(List<String> commandArguments) throws MojoExecutionException, IOException {
        for (int i = 0; i < this.arguments.size(); ++i) {
            Object argument = this.arguments.get(i);
            if (argument instanceof String && this.isLongClassPathArgument((String)argument)) {
                commandArguments.add("-jar");
                File tmpFile = this.createJar(this.computeClasspath((Classpath)this.arguments.get(i + 1)), (String)this.arguments.get(i + 2));
                commandArguments.add(tmpFile.getAbsolutePath());
                i += 2;
                continue;
            }
            if (argument instanceof Classpath) {
                Classpath specifiedClasspath = (Classpath)argument;
                String arg = this.computeClasspathString(specifiedClasspath);
                commandArguments.add(arg);
                continue;
            }
            commandArguments.add((String)argument);
        }
    }

    private void fillSuccessCodes(Executor exec) {
        if (this.successCodes != null && this.successCodes.length > 0) {
            exec.setExitValues(this.successCodes);
        }
    }

    boolean isResultCodeAFailure(int result) {
        if (this.successCodes == null || this.successCodes.length == 0) {
            return result != 0;
        }
        for (int successCode : this.successCodes) {
            if (successCode != result) continue;
            return false;
        }
        return true;
    }

    private boolean isLongClassPathArgument(String arg) {
        return this.longClasspath && ("-classpath".equals(arg) || "-cp".equals(arg));
    }

    private String computeClasspathString(Classpath specifiedClasspath) {
        List<String> resultList = this.computeClasspath(specifiedClasspath);
        StringBuffer theClasspath = new StringBuffer();
        for (String str : resultList) {
            ExecMojo.addToClasspath(theClasspath, str);
        }
        return theClasspath.toString();
    }

    private List<String> computeClasspath(Classpath specifiedClasspath) {
        List<Artifact> artifacts = new ArrayList<Artifact>();
        ArrayList<File> theClasspathFiles = new ArrayList<File>();
        ArrayList<String> resultList = new ArrayList<String>();
        this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
        if (specifiedClasspath != null && specifiedClasspath.getDependencies() != null) {
            artifacts = this.filterArtifacts(artifacts, specifiedClasspath.getDependencies());
        }
        for (File f : theClasspathFiles) {
            resultList.add(f.getAbsolutePath());
        }
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("dealing with " + artifact));
            resultList.add(artifact.getFile().getAbsolutePath());
        }
        return resultList;
    }

    private static void addToClasspath(StringBuffer theClasspath, String toAdd) {
        if (theClasspath.length() > 0) {
            theClasspath.append(File.pathSeparator);
        }
        theClasspath.append(toAdd);
    }

    private List<Artifact> filterArtifacts(List<Artifact> artifacts, Collection<String> dependencies) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new IncludesArtifactFilter(new ArrayList<String>(dependencies)));
        ArrayList<Artifact> filteredArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            this.getLog().debug((CharSequence)("filtering in " + artifact));
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    CommandLine getExecutablePath(Map<String, String> enviro, File dir) {
        CommandLine toRet;
        File execFile = new File(this.executable);
        String exec = null;
        if (execFile.isFile()) {
            this.getLog().debug((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            exec = execFile.getAbsolutePath();
        }
        if (exec == null) {
            Toolchain tc = this.getToolchain();
            if (tc != null) {
                this.getLog().info((CharSequence)("Toolchain in exec-maven-plugin: " + tc));
                exec = tc.findTool(this.executable);
            } else if (OS.isFamilyWindows()) {
                List<String> paths = this.getExecutablePaths(enviro);
                block0: for (String extension : this.WINDOWS_SPECIAL_EXTS) {
                    String ex = !this.executable.contains(".") ? this.executable + extension : this.executable;
                    File f = new File(dir, ex);
                    if (f.isFile()) {
                        exec = ex;
                    }
                    if (exec != null) continue;
                    for (String elem : paths) {
                        f = new File(new File(elem), ex);
                        if (!f.isFile()) continue;
                        exec = ex;
                        continue block0;
                    }
                }
            }
        }
        if (exec == null) {
            exec = this.executable;
        }
        if (OS.isFamilyWindows() && exec.toLowerCase(Locale.getDefault()).endsWith(".bat") || OS.isFamilyWindows() && exec.toLowerCase(Locale.getDefault()).endsWith(".cmd")) {
            toRet = new CommandLine("cmd");
            toRet.addArgument("/c");
            toRet.addArgument(exec);
        } else {
            toRet = new CommandLine(exec);
        }
        return toRet;
    }

    private List<String> getExecutablePaths(Map<String, String> enviro) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("");
        String path = enviro.get("PATH");
        if (path != null) {
            paths.addAll(Arrays.asList(StringUtils.split((String)path, (String)File.pathSeparator)));
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeCommandLine(Executor exec, CommandLine commandLine, Map<String, String> enviro, OutputStream out, OutputStream err) throws ExecuteException, IOException {
        int result;
        PumpStreamHandler psh = new PumpStreamHandler(out, err, System.in);
        exec.setStreamHandler((ExecuteStreamHandler)psh);
        try {
            psh.start();
            result = exec.execute(commandLine, enviro);
        }
        finally {
            psh.stop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeCommandLine(Executor exec, CommandLine commandLine, Map<String, String> enviro, FileOutputStream outputFile) throws ExecuteException, IOException {
        int result;
        BufferedOutputStream bos = new BufferedOutputStream(outputFile);
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)bos);
        exec.setStreamHandler((ExecuteStreamHandler)psh);
        try {
            psh.start();
            result = exec.execute(commandLine, enviro);
        }
        finally {
            psh.stop();
        }
        return result;
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    String getExecutable() {
        return this.executable;
    }

    void setWorkingDirectory(String workingDir) {
        this.setWorkingDirectory(new File(workingDir));
    }

    void setWorkingDirectory(File workingDir) {
        this.workingDirectory = workingDir;
    }

    void setArguments(List<?> arguments) {
        this.arguments = arguments;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    protected String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    public void setSuccessCodes(Integer ... list) {
        this.successCodes = new int[list.length];
        for (int index = 0; index < list.length; ++index) {
            this.successCodes[index] = list[index];
        }
    }

    public int[] getSuccessCodes() {
        return this.successCodes;
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    private File createJar(List<String> classPath, String mainClass) throws IOException {
        File file = File.createTempFile("maven-exec", ".jar");
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        JarOutputStream jos = new JarOutputStream(fos);
        jos.setLevel(0);
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        jos.putNextEntry(je);
        Manifest man = new Manifest();
        StringBuilder cp = new StringBuilder();
        for (String el : classPath) {
            cp.append(new URL(new File(el).toURI().toASCIIString()).toExternalForm() + " ");
        }
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("Class-Path", cp.toString().trim());
        man.getMainAttributes().putValue("Main-Class", mainClass);
        man.write(jos);
        jos.close();
        return file;
    }

    protected Map<String, String> createEnvs(File envScriptFile) throws MojoExecutionException {
        Map<String, String> results = null;
        File tmpEnvExecFile = null;
        try {
            tmpEnvExecFile = this.createEnvWrapperFile(envScriptFile);
            Commandline cl = new Commandline();
            cl.setExecutable(tmpEnvExecFile.getAbsolutePath());
            if (!OS.isFamilyWindows()) {
                cl.setExecutable("sh");
                cl.createArg().setFile(tmpEnvExecFile);
            }
            if (this.environmentVariables != null) {
                for (Map.Entry<String, String> item : this.environmentVariables.entrySet()) {
                    cl.addEnvironment(item.getKey(), item.getValue());
                }
            }
            EnvStreamConsumer stdout = new EnvStreamConsumer();
            DefaultConsumer stderr = new DefaultConsumer();
            CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
            results = stdout.getParsedEnv();
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            if (tmpEnvExecFile != null) {
                tmpEnvExecFile.delete();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createEnvWrapperFile(File envScript) throws IOException {
        File tmpFile;
        PrintWriter writer;
        block3: {
            writer = null;
            tmpFile = null;
            try {
                if (OS.isFamilyWindows()) {
                    tmpFile = File.createTempFile("env", ".bat");
                    writer = new PrintWriter(tmpFile);
                    writer.append("@echo off").println();
                    writer.append("call \"").append(envScript.getCanonicalPath()).append("\"").println();
                    writer.append("echo ================================This is the beginning of env parsing================================").println();
                    writer.append("set").println();
                    writer.flush();
                    break block3;
                }
                tmpFile = File.createTempFile("env", ".sh");
                writer = new PrintWriter(tmpFile);
                writer.append("#! /bin/sh").println();
                writer.append(". ").append(envScript.getCanonicalPath()).println();
                writer.append("echo ================================This is the beginning of env parsing================================").println();
                writer.append("env").println();
                writer.flush();
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return tmpFile;
    }
}

