/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.environment.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.environment.AbstractLogAwareFacet;
import org.codehaus.mojo.jaxb2.shared.environment.logging.MavenLogHandler;

public class LoggingHandlerEnvironmentFacet
extends AbstractLogAwareFacet {
    public static final String[] DEFAULT_LOGGER_NAMES = new String[]{"com.sun", "javax.xml", "javax.tools"};
    private boolean restored;
    private Logger rootLogger;
    private Level originalRootLoggerLevel;
    private List<Handler> originalHandlers;
    private MavenLogHandler mavenLogHandler;
    private String logPrefix;
    private String encoding;
    private String[] loggerNamePrefixes;

    public LoggingHandlerEnvironmentFacet(String logPrefix, Log mavenLog, String encoding, String[] loggerNamePrefixes) {
        super(mavenLog);
        Validate.notEmpty(encoding, "encoding");
        Validate.notNull(loggerNamePrefixes, "loggerNamePrefixes");
        this.originalHandlers = new ArrayList<Handler>();
        this.logPrefix = logPrefix;
        this.rootLogger = Logger.getLogger("");
        this.originalRootLoggerLevel = this.rootLogger.getLevel();
        this.encoding = encoding;
        this.loggerNamePrefixes = loggerNamePrefixes;
    }

    @Override
    public void setup() {
        this.rootLogger.setLevel(MavenLogHandler.getJavaUtilLoggingLevelFor(this.log));
        this.mavenLogHandler = new MavenLogHandler(this.log, this.logPrefix, this.encoding, this.loggerNamePrefixes);
        for (Handler current : this.rootLogger.getHandlers()) {
            this.originalHandlers.add(current);
            this.rootLogger.removeHandler(current);
        }
        this.rootLogger.addHandler(this.mavenLogHandler);
    }

    @Override
    public void restore() {
        if (!this.restored) {
            this.rootLogger.removeHandler(this.mavenLogHandler);
            this.rootLogger.setLevel(this.originalRootLoggerLevel);
            for (Handler current : this.originalHandlers) {
                this.rootLogger.addHandler(current);
            }
            this.restored = true;
        }
    }

    public static LoggingHandlerEnvironmentFacet create(Log mavenLog, Class<? extends AbstractJaxbMojo> caller, String encoding) {
        Validate.notNull(mavenLog, "mavenLog");
        Validate.notNull(caller, "caller");
        Validate.notEmpty(encoding, "encoding");
        String logPrefix = caller.getClass().getCanonicalName().toUpperCase().contains("XJC") ? "XJC" : "SchemaGen";
        return new LoggingHandlerEnvironmentFacet(logPrefix, mavenLog, encoding, DEFAULT_LOGGER_NAMES);
    }
}

