/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc;

import java.util.SortedMap;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.NodeProcessor;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.DomHelper;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocData;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.JavaDocRenderer;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.SearchableDocumentation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.ClassLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.FieldLocation;
import org.codehaus.mojo.jaxb2.schemageneration.postprocessing.javadoc.location.MethodLocation;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.w3c.dom.Node;

public class XsdAnnotationProcessor
implements NodeProcessor {
    private SortedMap<ClassLocation, JavaDocData> classJavaDocs;
    private SortedMap<FieldLocation, JavaDocData> fieldJavaDocs;
    private SortedMap<MethodLocation, JavaDocData> methodJavaDocs;
    private JavaDocRenderer renderer;

    public XsdAnnotationProcessor(SearchableDocumentation docs, JavaDocRenderer renderer) {
        Validate.notNull(docs, "docs");
        Validate.notNull(renderer, "renderer");
        this.classJavaDocs = docs.getAll(ClassLocation.class);
        this.fieldJavaDocs = docs.getAll(FieldLocation.class);
        this.methodJavaDocs = docs.getAll(MethodLocation.class);
        this.renderer = renderer;
    }

    @Override
    public boolean accept(Node aNode) {
        if (!DomHelper.isNamedElement(aNode)) {
            return false;
        }
        boolean toReturn = false;
        if (DomHelper.getMethodLocation(aNode, this.methodJavaDocs.keySet()) != null) {
            toReturn = true;
        } else if (DomHelper.getFieldLocation(aNode, this.fieldJavaDocs.keySet()) != null) {
            toReturn = true;
        } else if (DomHelper.getClassLocation(aNode, this.classJavaDocs.keySet()) != null) {
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public void process(Node aNode) {
        DomHelper.insertXmlDocumentationAnnotationsFor(aNode, this.classJavaDocs, this.fieldJavaDocs, this.methodJavaDocs, this.renderer);
    }
}

