/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class RequiredMavenVersionFinder {
    private final MavenProject mavenProject;

    RequiredMavenVersionFinder(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    ArtifactVersion find() {
        ArtifactVersion childMavenVersion = this.getHighestArtifactVersion(this.getPrerequisitesMavenVersion(), this.getEnforcerMavenVersion());
        if (!this.mavenProject.hasParent()) {
            return childMavenVersion;
        }
        ArtifactVersion parentMavenVersion = new RequiredMavenVersionFinder(this.mavenProject.getParent()).find();
        return this.getHighestArtifactVersion(childMavenVersion, parentMavenVersion);
    }

    private ArtifactVersion getPrerequisitesMavenVersion() {
        Prerequisites prerequisites = this.mavenProject.getPrerequisites();
        if (null == prerequisites) {
            return null;
        }
        String prerequisitesMavenValue = prerequisites.getMaven();
        if (null == prerequisitesMavenValue) {
            return null;
        }
        return new DefaultArtifactVersion(prerequisitesMavenValue);
    }

    private ArtifactVersion getEnforcerMavenVersion() {
        List buildPlugins = this.mavenProject.getBuildPlugins();
        if (null == buildPlugins) {
            return null;
        }
        Plugin mavenEnforcerPlugin = this.getMavenEnforcerPlugin(buildPlugins);
        if (null == mavenEnforcerPlugin) {
            return null;
        }
        List pluginExecutions = mavenEnforcerPlugin.getExecutions();
        if (null == pluginExecutions) {
            return null;
        }
        List<PluginExecution> pluginExecutionsWithEnforceGoal = this.getPluginExecutionsWithEnforceGoal(pluginExecutions);
        if (pluginExecutionsWithEnforceGoal.isEmpty()) {
            return null;
        }
        Xpp3Dom requireMavenVersionTag = this.getRequireMavenVersionTag(pluginExecutionsWithEnforceGoal);
        if (null == requireMavenVersionTag) {
            return null;
        }
        Xpp3Dom versionTag = requireMavenVersionTag.getChild("version");
        if (null == versionTag) {
            return null;
        }
        String versionTagValue = versionTag.getValue();
        if (null == versionTagValue || "".equals(versionTagValue)) {
            return null;
        }
        return this.processMavenVersionRange(versionTagValue);
    }

    private Plugin getMavenEnforcerPlugin(List<Plugin> buildPlugins) {
        for (Plugin plugin : buildPlugins) {
            if (!"maven-enforcer-plugin".equals(plugin.getArtifactId())) continue;
            return plugin;
        }
        return null;
    }

    private List<PluginExecution> getPluginExecutionsWithEnforceGoal(List<PluginExecution> executions) {
        ArrayList<PluginExecution> pluginExecutions = new ArrayList<PluginExecution>();
        for (PluginExecution pluginExecution : executions) {
            List goals = pluginExecution.getGoals();
            if (goals == null || !goals.contains("enforce")) continue;
            pluginExecutions.add(pluginExecution);
        }
        return pluginExecutions;
    }

    private Xpp3Dom getRequireMavenVersionTag(List<PluginExecution> executions) {
        for (PluginExecution pluginExecution : executions) {
            Xpp3Dom requireMavenVersionTag;
            Xpp3Dom rulesTag;
            Xpp3Dom configurationTag = (Xpp3Dom)pluginExecution.getConfiguration();
            if (null == configurationTag || null == (rulesTag = configurationTag.getChild("rules")) || null == (requireMavenVersionTag = rulesTag.getChild("requireMavenVersion"))) continue;
            return requireMavenVersionTag;
        }
        return null;
    }

    private ArtifactVersion getHighestArtifactVersion(ArtifactVersion firstMavenVersion, ArtifactVersion secondMavenVersion) {
        if (null == firstMavenVersion && null == secondMavenVersion) {
            return null;
        }
        if (null == firstMavenVersion) {
            return secondMavenVersion;
        }
        if (null == secondMavenVersion) {
            return firstMavenVersion;
        }
        if (firstMavenVersion.compareTo((Object)secondMavenVersion) < 0) {
            return secondMavenVersion;
        }
        return firstMavenVersion;
    }

    private ArtifactVersion processMavenVersionRange(String versionRange) {
        int openIndicesCount = 0;
        int closeIndicesCount = 0;
        for (int i = 0; i < versionRange.length(); ++i) {
            char character = versionRange.charAt(i);
            if ('(' == character || '[' == character) {
                ++openIndicesCount;
                continue;
            }
            if (')' != character && ']' != character) continue;
            ++closeIndicesCount;
        }
        if (openIndicesCount != closeIndicesCount) {
            return null;
        }
        if (openIndicesCount == 0) {
            return new DefaultArtifactVersion(versionRange);
        }
        if (versionRange.charAt(0) != '[' && versionRange.charAt(0) != '(' || versionRange.charAt(versionRange.length() - 1) != ']' && versionRange.charAt(versionRange.length() - 1) != ')') {
            return null;
        }
        if (openIndicesCount != 1) {
            return null;
        }
        String innerString = versionRange.substring(1, versionRange.length() - 1);
        int commaIndex = innerString.indexOf(44);
        if (commaIndex == -1) {
            if (versionRange.charAt(0) == '[' && versionRange.charAt(versionRange.length() - 1) == ']') {
                return new DefaultArtifactVersion(innerString);
            }
            return null;
        }
        if (commaIndex == 0) {
            return null;
        }
        if (commaIndex == innerString.length() - 1) {
            String minimumVersion = innerString.substring(0, innerString.length() - 1);
            if (versionRange.charAt(0) == '[' && versionRange.charAt(versionRange.length() - 1) == ')') {
                return new DefaultArtifactVersion(minimumVersion);
            }
            if (versionRange.charAt(0) == '(' && versionRange.charAt(versionRange.length() - 1) == ')') {
                return new DefaultArtifactVersion(minimumVersion);
            }
            return null;
        }
        String minimumVersion = innerString.substring(0, commaIndex);
        if (versionRange.charAt(0) == '[') {
            return new DefaultArtifactVersion(minimumVersion);
        }
        if (versionRange.charAt(0) == '(') {
            return new DefaultArtifactVersion(minimumVersion);
        }
        return null;
    }
}

