/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.collections.ActiveMap;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractActiveMap
implements ActiveMap,
Contextualizable,
LogEnabled {
    private String role;
    private PlexusContainer container;
    private Logger logger;

    protected AbstractActiveMap() {
    }

    protected AbstractActiveMap(PlexusContainer container, String role) {
        this.container = container;
        this.role = role;
        this.logger = container.getLoggerManager().getLoggerForComponent(ActiveMap.ROLE);
    }

    public void clear() {
        throw new UnsupportedOperationException("ActiveMap implementations are not mutable.");
    }

    public Object put(Object arg0, Object arg1) {
        throw new UnsupportedOperationException("ActiveMap implementations are not mutable.");
    }

    public void putAll(Map arg0) {
        throw new UnsupportedOperationException("ActiveMap implementations are not mutable.");
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("ActiveMap implementations are not mutable.");
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected final Map getMap() {
        try {
            return this.checkedGetMap();
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Failed to lookup map for role: " + this.role, (Throwable)e);
            return Collections.EMPTY_MAP;
        }
    }

    protected final Map checkedGetMap() throws ComponentLookupException {
        return this.container.lookupMap(this.role);
    }

    public final String getRole() {
        return this.role;
    }

    protected final void setRole(String role) {
        this.role = role;
    }

    public final void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public final void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public abstract /* synthetic */ Collection checkedValues() throws ComponentLookupException;

    public abstract /* synthetic */ Set checkedKeySet() throws ComponentLookupException;

    public abstract /* synthetic */ Object checkedGet(Object var1) throws ComponentLookupException;

    public abstract /* synthetic */ Set checkedEntrySet() throws ComponentLookupException;

    public abstract /* synthetic */ boolean checkedContainsValue(Object var1) throws ComponentLookupException;

    public abstract /* synthetic */ boolean checkedContainsKey(Object var1) throws ComponentLookupException;

    public abstract /* synthetic */ int checkedSize() throws ComponentLookupException;

    public abstract /* synthetic */ int size();

    public abstract /* synthetic */ boolean checkedIsEmpty() throws ComponentLookupException;

    public abstract /* synthetic */ boolean isEmpty();

    public abstract /* synthetic */ Set entrySet();

    public abstract /* synthetic */ Collection values();

    public abstract /* synthetic */ Set keySet();

    public abstract /* synthetic */ Object get(Object var1);

    public abstract /* synthetic */ boolean containsValue(Object var1);

    public abstract /* synthetic */ boolean containsKey(Object var1);
}

