/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.IOUtil;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static boolean isUptodate(PlexusIoResource source, File destination) {
        return ResourceUtils.isUptodate(source, destination.lastModified());
    }

    public static boolean isUptodate(PlexusIoResource source, long destinationDate) {
        long s = source.getLastModified();
        if (s == 0L) {
            return false;
        }
        if (destinationDate == 0L) {
            return false;
        }
        return destinationDate > s;
    }

    public static boolean isUptodate(long sourceDate, long destinationDate) {
        if (sourceDate == 0L) {
            return false;
        }
        if (destinationDate == 0L) {
            return false;
        }
        return destinationDate > sourceDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(PlexusIoResource in, File outFile) throws IOException {
        InputStream input = null;
        FileOutputStream output = null;
        try {
            input = in.getContents();
            output = new FileOutputStream(outFile);
            IOUtil.copy((InputStream)input, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtil.close((InputStream)input);
            IOUtil.close(output);
            throw throwable;
        }
        IOUtil.close((InputStream)input);
        IOUtil.close((OutputStream)output);
    }

    public static boolean isSame(PlexusIoResource resource, File file) {
        if (resource instanceof PlexusIoFileResource) {
            File resourceFile = ((PlexusIoFileResource)resource).getFile();
            return file.equals(resourceFile);
        }
        return false;
    }

    public static boolean isCanonicalizedSame(PlexusIoResource resource, File file) throws IOException {
        if (resource instanceof PlexusIoFileResource) {
            File resourceFile = ((PlexusIoFileResource)resource).getFile();
            return file.getCanonicalFile().equals(resourceFile.getCanonicalFile());
        }
        return false;
    }
}

