/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.ArtifactDownloader;

public class JdbcDriverHolder {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDriverHolder.class);
    private JdbcDriverClassLoader classLoader;

    public JdbcDriverHolder(ArtifactDownloader extensionDownloader) {
        this(extensionDownloader.downloadJdbcDriver());
    }

    JdbcDriverHolder(File jdbcDriver) {
        try {
            ClassLoader parentClassLoader = JdbcDriverHolder.class.getClassLoader();
            this.classLoader = new JdbcDriverClassLoader(jdbcDriver.toURI().toURL(), parentClassLoader);
        }
        catch (MalformedURLException e) {
            throw new SonarException("Fail to get URL of : " + jdbcDriver.getAbsolutePath(), (Throwable)e);
        }
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void stop() {
        this.classLoader.clearReferencesJdbc();
        this.classLoader = null;
    }

    private static class JdbcDriverClassLoader
    extends URLClassLoader {
        public JdbcDriverClassLoader(URL jdbcDriver, ClassLoader parent) {
            super(new URL[]{jdbcDriver}, parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearReferencesJdbc() {
            InputStream is = this.getResourceAsStream("org/sonar/batch/bootstrap/JdbcLeakPrevention.class");
            byte[] classBytes = new byte[2048];
            int offset = 0;
            try {
                int read = is.read(classBytes, offset, classBytes.length - offset);
                while (read > -1) {
                    if ((offset += read) == classBytes.length) {
                        byte[] tmp = new byte[classBytes.length * 2];
                        System.arraycopy(classBytes, 0, tmp, 0, classBytes.length);
                        classBytes = tmp;
                    }
                    read = is.read(classBytes, offset, classBytes.length - offset);
                }
                Class<?> lpClass = this.defineClass("org.sonar.batch.bootstrap.JdbcLeakPrevention", classBytes, 0, offset, this.getClass().getProtectionDomain());
                Object obj = lpClass.newInstance();
                List driverNames = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
                for (String name : driverNames) {
                    LOG.debug("To prevent a memory leak, the JDBC Driver [{}] has been forcibly deregistered", (Object)name);
                }
            }
            catch (Exception e) {
                LOG.warn("JDBC driver deregistration failed", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn(ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
        }
    }
}

