/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;

public class ProjectFilter {
    private Settings settings;

    public ProjectFilter(Settings settings) {
        this.settings = settings;
    }

    public boolean isExcluded(Project project) {
        for (Project p = project; p != null; p = p.getParent()) {
            if (!this.isExcludedModule(ProjectFilter.getArtifactId(p), p.isRoot())) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludedModule(String artifactId, boolean isRoot) {
        Object[] includedArtifactIds = this.settings.getStringArray("sonar.includedModules");
        boolean excluded = false;
        if (!isRoot && includedArtifactIds.length > 0) {
            boolean bl = excluded = !ArrayUtils.contains((Object[])includedArtifactIds, (Object)artifactId);
        }
        if (!excluded) {
            Object[] excludedArtifactIds = this.settings.getStringArray("sonar.skippedModules");
            excluded = ArrayUtils.contains((Object[])excludedArtifactIds, (Object)artifactId);
        }
        if (excluded && isRoot) {
            throw new IllegalArgumentException("The root module can't be skipped. Please check the parameter sonar.skippedModules.");
        }
        return excluded;
    }

    static String getArtifactId(Project project) {
        String key = project.getKey();
        if (StringUtils.isNotBlank((String)project.getBranch())) {
            key = StringUtils.removeEnd((String)project.getKey(), (String)(":" + project.getBranch()));
        }
        if (key.contains(":")) {
            return StringUtils.substringAfter((String)key, (String)":");
        }
        return key;
    }
}

