/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.MavenPluginExecutor;
import org.sonar.batch.MavenProjectConverter;

public abstract class AbstractMavenPluginExecutor
implements MavenPluginExecutor {
    public final MavenPluginHandler execute(Project project, ProjectDefinition projectDefinition, MavenPluginHandler handler) {
        for (String goal : handler.getGoals()) {
            MavenPlugin plugin = MavenPlugin.getPlugin((MavenProject)project.getPom(), (String)handler.getGroupId(), (String)handler.getArtifactId());
            this.execute(project, projectDefinition, AbstractMavenPluginExecutor.getGoal(handler.getGroupId(), handler.getArtifactId(), plugin != null && plugin.getPlugin() != null ? plugin.getPlugin().getVersion() : null, goal));
        }
        return handler;
    }

    public final void execute(Project project, ProjectDefinition projectDefinition, String goal) {
        TimeProfiler profiler = new TimeProfiler().start("Execute " + goal);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.concreteExecute(project.getPom(), goal);
        }
        catch (Exception e) {
            throw new SonarException("Unable to execute maven plugin", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            profiler.stop();
        }
        if (project.getPom() != null) {
            MavenProjectConverter.synchronizeFileSystem(project.getPom(), projectDefinition);
        }
    }

    public abstract void concreteExecute(MavenProject var1, String var2) throws Exception;

    static String getGoal(String groupId, String artifactId, String version, String goal) {
        String defaultVersion = version == null ? "" : version;
        return groupId + ":" + artifactId + ":" + defaultVersion + ":" + goal;
    }
}

