/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.resources.Project;
import org.sonar.batch.ProjectConfigurator;
import org.sonar.batch.bootstrap.ProjectFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTree {
    private final ProjectConfigurator configurator;
    private ProjectReactor projectReactor;
    private List<Project> projects;
    private Map<ProjectDefinition, Project> projectsByDef;
    private ProjectFilter projectFilter;

    public ProjectTree(ProjectReactor projectReactor, ProjectConfigurator projectConfigurator, ProjectFilter projectFilter, ProjectBuilder[] builders) {
        this(projectReactor, projectConfigurator, projectFilter);
    }

    public ProjectTree(ProjectReactor projectReactor, ProjectConfigurator projectConfigurator, ProjectFilter projectFilter) {
        this.projectReactor = projectReactor;
        this.configurator = projectConfigurator;
        this.projectFilter = projectFilter;
    }

    ProjectTree(ProjectConfigurator configurator) {
        this.configurator = configurator;
    }

    public void start() {
        this.doStart(this.projectReactor.getProjects());
    }

    void doStart(List<ProjectDefinition> definitions) {
        this.projects = Lists.newArrayList();
        this.projectsByDef = Maps.newHashMap();
        for (ProjectDefinition projectDefinition : definitions) {
            Project project = this.configurator.create(projectDefinition);
            this.projectsByDef.put(projectDefinition, project);
            this.projects.add(project);
        }
        for (Map.Entry entry : this.projectsByDef.entrySet()) {
            ProjectDefinition def = (ProjectDefinition)entry.getKey();
            Project project = (Project)entry.getValue();
            for (ProjectDefinition module : def.getSubProjects()) {
                this.projectsByDef.get(module).setParent(project);
            }
        }
        for (Project project : this.projects) {
            this.configurator.configure(project);
        }
        this.applyExclusions();
    }

    void applyExclusions() {
        Iterator<Project> it = this.projects.iterator();
        while (it.hasNext()) {
            Project project = it.next();
            if (!this.projectFilter.isExcluded(project)) continue;
            project.setExcluded(true);
            LoggerFactory.getLogger(this.getClass()).info("Project {} excluded", (Object)project.getName());
            project.removeFromParent();
            it.remove();
        }
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public Project getRootProject() {
        for (Project project : this.projects) {
            if (project.getParent() != null) continue;
            return project;
        }
        throw new IllegalStateException("Can not find the root project from the list of Maven modules");
    }

    public ProjectDefinition getProjectDefinition(Project project) {
        for (Map.Entry<ProjectDefinition, Project> entry : this.projectsByDef.entrySet()) {
            if (!ObjectUtils.equals((Object)entry.getValue(), (Object)project)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Can not find ProjectDefinition for " + project);
    }
}

