/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.IOUtil;
import org.sonar.api.BatchComponent;
import org.sonar.api.platform.Server;

public class RemoteServerMetadata
implements BatchComponent {
    public static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int READ_TIMEOUT_MILLISECONDS = 60000;
    private String serverUrl;

    public RemoteServerMetadata(Server server) {
        this.serverUrl = server.getURL();
        if (this.serverUrl.endsWith("/")) {
            this.serverUrl = StringUtils.chop((String)this.serverUrl);
        }
    }

    public String getServerId() throws IOException {
        String remoteServerInfo = this.remoteContent("/api/server");
        return this.extractId(remoteServerInfo);
    }

    protected String extractId(String remoteServerInfo) {
        String partialId = StringUtils.substringAfter((String)remoteServerInfo, (String)"\"id\":\"");
        return StringUtils.substringBefore((String)partialId, (String)"\"");
    }

    protected String getUrlFor(String path) {
        return this.serverUrl + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String remoteContent(String path) throws IOException {
        String fullUrl = this.getUrlFor(path);
        HttpURLConnection conn = RemoteServerMetadata.getConnection(fullUrl, "GET");
        InputStream input = (InputStream)conn.getContent();
        try {
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                throw new IOException("Status returned by url : '" + fullUrl + "' is invalid : " + statusCode);
            }
            String string = IOUtil.toString((InputStream)input);
            return string;
        }
        finally {
            IOUtil.close((InputStream)input);
            conn.disconnect();
        }
    }

    static HttpURLConnection getConnection(String url, String method) throws IOException {
        URL page = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)page.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(60000);
        conn.setRequestMethod(method);
        conn.connect();
        return conn;
    }
}

