/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TempFileUtils;

public final class TempDirectories {
    public static final String DIR_PREFIX = "sonar-batch";
    public static final int AGE_BEFORE_DELETION = 86400000;
    private File rootDir;
    private Map<String, File> directoriesByKey = Maps.newHashMap();

    public TempDirectories() throws IOException {
        this.rootDir = TempFileUtils.createTempDirectory((String)DIR_PREFIX);
        LoggerFactory.getLogger(this.getClass()).debug("Temporary directory: " + this.rootDir.getAbsolutePath());
    }

    public File getRoot() {
        return this.rootDir;
    }

    public File getDir(String key) {
        if (StringUtils.isBlank((String)key)) {
            return this.rootDir;
        }
        File dir = this.directoriesByKey.get(key);
        if (dir == null) {
            dir = new File(this.rootDir, key);
            try {
                FileUtils.forceMkdir((File)dir);
                this.directoriesByKey.put(key, dir);
            }
            catch (IOException e) {
                throw new SonarException("Can not create the temp directory: " + dir, (Throwable)e);
            }
        }
        return dir;
    }

    public File getFile(String directoryKey, String filename) {
        File dir = this.getDir(directoryKey);
        return new File(dir, filename);
    }

    public void stop() {
        File[] directoriesToDelete;
        this.directoriesByKey.clear();
        this.rootDir.setLastModified(System.currentTimeMillis() - 86400000L - 3600000L);
        for (File dir : directoriesToDelete = this.rootDir.getParentFile().listFiles((FileFilter)new AndFileFilter(Arrays.asList(DirectoryFileFilter.DIRECTORY, new PrefixFileFilter(DIR_PREFIX), new AgeFileFilter(System.currentTimeMillis() - 86400000L))))) {
            LoggerFactory.getLogger(this.getClass()).debug("Delete temporary directory: " + dir);
            FileUtils.deleteQuietly((File)dir);
        }
    }
}

