/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.components.PastSnapshot;

public class PastSnapshotFinderByPreviousAnalysis
implements BatchExtension {
    private DatabaseSession session;

    public PastSnapshotFinderByPreviousAnalysis(DatabaseSession session) {
        this.session = session;
    }

    PastSnapshot findByPreviousAnalysis(Snapshot projectSnapshot) {
        String hql = "from " + Snapshot.class.getSimpleName() + " where createdAt<:date AND resourceId=:resourceId AND status=:status and last=:last and qualifier<>:lib order by createdAt desc";
        List snapshots = this.session.createQuery(hql).setParameter("date", (Object)projectSnapshot.getCreatedAt()).setParameter("resourceId", (Object)projectSnapshot.getResourceId()).setParameter("status", (Object)"P").setParameter("last", (Object)true).setParameter("lib", (Object)"LIB").setMaxResults(1).getResultList();
        if (snapshots.isEmpty()) {
            return new PastSnapshot("previous_analysis");
        }
        Snapshot snapshot = (Snapshot)snapshots.get(0);
        Date targetDate = snapshot.getCreatedAt();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return new PastSnapshot("previous_analysis", targetDate, snapshot).setModeParameter(format.format(targetDate));
    }
}

