/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.config.BatchSettings;
import org.sonar.core.properties.PropertiesDao;
import org.sonar.core.properties.PropertyDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchDatabaseSettingsLoader {
    private PropertiesDao propertiesDao;
    private BatchSettings settings;
    private ProjectReactor reactor;

    public BatchDatabaseSettingsLoader(PropertiesDao propertiesDao, BatchSettings settings, ProjectReactor reactor) {
        this.propertiesDao = propertiesDao;
        this.settings = settings;
        this.reactor = reactor;
    }

    public void start() {
        String branch = this.settings.getString("sonar.branch");
        String projectKey = this.reactor.getRoot().getKey();
        if (StringUtils.isNotBlank((String)branch)) {
            projectKey = String.format("%s:%s", projectKey, branch);
        }
        this.setIfNotDefined(this.propertiesDao.selectProjectProperties(projectKey));
        this.setIfNotDefined(this.propertiesDao.selectGlobalProperties());
        this.settings.updateDeprecatedCommonsConfiguration();
    }

    private void setIfNotDefined(List<PropertyDto> dbProperties) {
        for (PropertyDto dbProperty : dbProperties) {
            if (this.settings.hasKey(dbProperty.getKey())) continue;
            this.settings.setProperty(dbProperty.getKey(), dbProperty.getValue());
        }
    }
}

