/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import java.util.List;
import javax.persistence.Query;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.ServerMetadata;
import org.sonar.batch.index.ResourcePersister;
import org.sonar.core.NotDryRun;

@NotDryRun
public class UpdateStatusJob
implements BatchComponent {
    private DatabaseSession session;
    private ServerMetadata server;
    private Snapshot snapshot;
    private ResourcePersister resourcePersister;

    public UpdateStatusJob(ServerMetadata server, DatabaseSession session, ResourcePersister resourcePersister, Snapshot snapshot) {
        this.session = session;
        this.server = server;
        this.resourcePersister = resourcePersister;
        this.snapshot = snapshot;
    }

    public void execute() {
        this.disablePreviousSnapshot();
        this.enableCurrentSnapshot();
    }

    private void disablePreviousSnapshot() {
        Query query = this.session.createQuery("FROM " + Snapshot.class.getSimpleName() + " WHERE (root_snapshot_id=:rootId OR id=:rootId) AND scope=:scope");
        query.setParameter("rootId", (Object)this.snapshot.getId());
        query.setParameter("scope", (Object)"PRJ");
        List moduleSnapshots = query.getResultList();
        for (Snapshot moduleSnapshot : moduleSnapshots) {
            Snapshot previousLastSnapshot = this.resourcePersister.getLastSnapshot(moduleSnapshot, true);
            if (previousLastSnapshot == null) continue;
            this.setFlags(previousLastSnapshot, false, null);
        }
    }

    private void enableCurrentSnapshot() {
        Snapshot previousLastSnapshot = this.resourcePersister.getLastSnapshot(this.snapshot, false);
        boolean isLast = previousLastSnapshot == null || previousLastSnapshot.getCreatedAt().before(this.snapshot.getCreatedAt());
        this.setFlags(this.snapshot, isLast, "P");
        LoggerFactory.getLogger(this.getClass()).info("ANALYSIS SUCCESSFUL, you can browse {}", (Object)this.server.getURL());
    }

    private void setFlags(Snapshot snapshot, boolean last, String status) {
        String hql = "UPDATE " + Snapshot.class.getSimpleName() + " SET last=:last";
        if (status != null) {
            hql = hql + ", status=:status ";
        }
        hql = hql + " WHERE root_snapshot_id=:rootId OR id=:rootId OR (path LIKE :path AND root_snapshot_id=:pathRootId)";
        Query query = this.session.createQuery(hql);
        if (status != null) {
            query.setParameter("status", (Object)status);
            snapshot.setStatus(status);
        }
        query.setParameter("last", (Object)last);
        query.setParameter("rootId", (Object)snapshot.getId());
        query.setParameter("path", (Object)(snapshot.getPath() + snapshot.getId() + ".%"));
        query.setParameter("pathRootId", (Object)(snapshot.getRootId() == null ? snapshot.getId() : snapshot.getRootId()));
        query.executeUpdate();
        this.session.commit();
        snapshot.setLast(Boolean.valueOf(last));
    }
}

