/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.resources.ProjectFileSystem;

public class DefaultProjectClasspath
extends ProjectClasspath {
    private ProjectDefinition def;
    private ProjectFileSystem projectFileSystem;

    public DefaultProjectClasspath(ProjectDefinition def, ProjectFileSystem projectFileSystem) {
        this(def, projectFileSystem, null);
    }

    public DefaultProjectClasspath(ProjectDefinition def, ProjectFileSystem projectFileSystem, MavenProject pom) {
        super(pom);
        this.def = def;
        this.projectFileSystem = projectFileSystem;
    }

    protected List<File> createElements() {
        if (this.pom != null) {
            return super.createElements();
        }
        ArrayList elements = Lists.newArrayList();
        for (String path : this.def.getBinaries()) {
            elements.add(this.projectFileSystem.resolvePath(path));
        }
        for (String path : this.def.getLibraries()) {
            elements.add(this.projectFileSystem.resolvePath(path));
        }
        return elements;
    }
}

