/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.rules.Violation;
import org.sonar.api.rules.ViolationFilter;

public class ViolationFilters {
    private static final Logger LOG = LoggerFactory.getLogger(ViolationFilters.class);
    private ViolationFilter[] filters;

    public ViolationFilters(ViolationFilter[] filters) {
        this.filters = filters;
    }

    public ViolationFilters() {
        this(new ViolationFilter[0]);
    }

    public boolean isEmpty() {
        return this.filters.length == 0;
    }

    public boolean isIgnored(Violation violation) {
        boolean ignored = false;
        for (int index = 0; !ignored && index < this.filters.length; ++index) {
            ignored = this.filters[index].isIgnored(violation);
            if (!ignored || !LOG.isDebugEnabled()) continue;
            LOG.debug("Violation {} is excluded by the filter {}", (Object)violation, (Object)this.filters[index]);
        }
        return ignored;
    }
}

