/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONValue;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.BootstrapSettings;
import org.sonar.batch.bootstrap.ServerClient;

public class BatchSettings
extends Settings {
    public static final String BATCH_BOOTSTRAP_PROPERTIES_URL = "/batch_bootstrap/properties";
    private Configuration deprecatedConfiguration;
    private boolean preview;
    private final BootstrapSettings bootstrapSettings;
    private final ServerClient client;
    private final AnalysisMode mode;
    private Map<String, String> savedProperties;

    public BatchSettings(BootstrapSettings bootstrapSettings, PropertyDefinitions propertyDefinitions, ServerClient client, Configuration deprecatedConfiguration, AnalysisMode mode) {
        super(propertyDefinitions);
        this.mode = mode;
        this.getEncryption().setPathToSecretKey(bootstrapSettings.property("sonar.secretKeyPath"));
        this.bootstrapSettings = bootstrapSettings;
        this.client = client;
        this.deprecatedConfiguration = deprecatedConfiguration;
        this.init(null);
    }

    public void init(@Nullable ProjectReactor reactor) {
        this.savedProperties = this.getProperties();
        this.preview = this.mode.isPreview();
        if (reactor != null) {
            LoggerFactory.getLogger(BatchSettings.class).info("Load project settings");
            String branch = this.bootstrapSettings.property("sonar.branch");
            String projectKey = reactor.getRoot().getKey();
            if (StringUtils.isNotBlank((String)branch)) {
                projectKey = String.format("%s:%s", projectKey, branch);
            }
            this.downloadSettings(projectKey);
        } else {
            LoggerFactory.getLogger(BatchSettings.class).info("Load batch settings");
            this.downloadSettings(null);
        }
        this.addProperties(this.bootstrapSettings.properties());
        if (reactor != null) {
            this.addProperties(reactor.getRoot().getProperties());
        }
        this.properties.putAll(System.getenv());
        this.addProperties(System.getProperties());
    }

    public void restore() {
        this.setProperties(this.savedProperties);
    }

    private void downloadSettings(@Nullable String projectKey) {
        String url = StringUtils.isNotBlank((String)projectKey) ? "/batch_bootstrap/properties?project=" + projectKey + "&dryRun=" + this.preview : "/batch_bootstrap/properties?dryRun=" + this.preview;
        String jsonText = this.client.request(url);
        List json = (List)JSONValue.parse((String)jsonText);
        for (Map jsonProperty : json) {
            String key = (String)jsonProperty.get("k");
            String value = (String)jsonProperty.get("v");
            this.setProperty(key, value);
        }
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedConfiguration.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedConfiguration.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedConfiguration.clear();
    }

    protected void doOnGetProperties(String key) {
        if (this.preview && key.endsWith(".secured") && !key.contains(".license")) {
            throw new SonarException("Access to the secured property '" + key + "' is not possible in preview mode. The SonarQube plugin which requires this property must be deactivated in preview mode.");
        }
    }
}

