/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.bootstrap.BootstrapContainer;
import org.sonar.batch.bootstrap.BootstrapProperties;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.LoggingConfiguration;

public final class Batch {
    private LoggingConfiguration logging;
    private List<Object> components;
    private Map<String, String> bootstrapProperties = Maps.newHashMap();
    @Deprecated
    private ProjectReactor projectReactor;

    private Batch(Builder builder) {
        this.components = Lists.newArrayList();
        this.components.addAll(builder.components);
        if (builder.environment != null) {
            this.components.add(builder.environment);
        }
        if (builder.bootstrapProperties != null) {
            this.bootstrapProperties.putAll(builder.bootstrapProperties);
        } else if (builder.projectReactor != null) {
            this.bootstrapProperties.putAll((Map<String, String>)Maps.fromProperties((Properties)builder.projectReactor.getRoot().getProperties()));
        }
        this.projectReactor = builder.projectReactor;
        if (builder.isEnableLoggingConfiguration()) {
            this.logging = LoggingConfiguration.create(builder.environment).setProperties(this.bootstrapProperties);
        }
    }

    public LoggingConfiguration getLoggingConfiguration() {
        return this.logging;
    }

    public Batch execute() {
        this.configureLogging();
        this.startBatch();
        return this;
    }

    private void configureLogging() {
        if (this.logging != null) {
            this.logging.configure();
        }
    }

    private void startBatch() {
        ArrayList all = Lists.newArrayList(this.components);
        all.add(new BootstrapProperties(this.bootstrapProperties));
        if (this.projectReactor != null) {
            all.add(this.projectReactor);
        }
        BootstrapContainer bootstrapContainer = BootstrapContainer.create(all);
        bootstrapContainer.execute();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, String> bootstrapProperties;
        @Deprecated
        private ProjectReactor projectReactor;
        private EnvironmentInformation environment;
        private List<Object> components = Lists.newArrayList();
        private boolean enableLoggingConfiguration = true;

        private Builder() {
        }

        @Deprecated
        public Builder setProjectReactor(ProjectReactor projectReactor) {
            this.projectReactor = projectReactor;
            return this;
        }

        public Builder setEnvironment(EnvironmentInformation env) {
            this.environment = env;
            return this;
        }

        public Builder setComponents(List<Object> l) {
            this.components = l;
            return this;
        }

        @Deprecated
        public Builder setGlobalProperties(Map<String, String> globalProperties) {
            this.bootstrapProperties = globalProperties;
            return this;
        }

        public Builder setBootstrapProperties(Map<String, String> bootstrapProperties) {
            this.bootstrapProperties = bootstrapProperties;
            return this;
        }

        public Builder addComponents(Object ... components) {
            Collections.addAll(this.components, components);
            return this;
        }

        public Builder addComponent(Object component) {
            this.components.add(component);
            return this;
        }

        public boolean isEnableLoggingConfiguration() {
            return this.enableLoggingConfiguration;
        }

        public Builder setEnableLoggingConfiguration(boolean b) {
            this.enableLoggingConfiguration = b;
            return this;
        }

        public Batch build() {
            if (this.components == null) {
                throw new IllegalStateException("Batch components are not set");
            }
            return new Batch(this);
        }
    }
}

