/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.Period;
import org.sonar.batch.components.PeriodsDefinition;

public class TimeMachineConfiguration
implements BatchExtension {
    private static final Logger LOG = LoggerFactory.getLogger(TimeMachineConfiguration.class);
    private final DatabaseSession session;
    private Project project;
    private final PeriodsDefinition periodsDefinition;
    private List<Period> periods;
    private List<PastSnapshot> modulePastSnapshots;

    public TimeMachineConfiguration(DatabaseSession session, Project project, PeriodsDefinition periodsDefinition) {
        this.session = session;
        this.project = project;
        this.periodsDefinition = periodsDefinition;
        this.initModulePastSnapshots();
    }

    private void initModulePastSnapshots() {
        this.periods = Lists.newLinkedList();
        this.modulePastSnapshots = Lists.newLinkedList();
        for (PastSnapshot projectPastSnapshot : this.periodsDefinition.getRootProjectPastSnapshots()) {
            Snapshot snapshot = this.findSnapshot(projectPastSnapshot.getProjectSnapshot());
            PastSnapshot pastSnapshot = new PastSnapshot(projectPastSnapshot.getMode(), projectPastSnapshot.getTargetDate(), projectPastSnapshot.getProjectSnapshot());
            pastSnapshot.setIndex(projectPastSnapshot.getIndex());
            pastSnapshot.setModeParameter(projectPastSnapshot.getModeParameter());
            this.modulePastSnapshots.add(pastSnapshot);
            this.periods.add(new Period(pastSnapshot.getIndex(), pastSnapshot.getTargetDate(), snapshot != null ? snapshot.getCreatedAt() : null));
            this.log(pastSnapshot);
        }
    }

    @CheckForNull
    private Snapshot findSnapshot(Snapshot projectSnapshot) {
        String hql = "from " + Snapshot.class.getSimpleName() + " where resourceId=:resourceId and (rootId=:rootSnapshotId or id=:rootSnapshotId)";
        List snapshots = this.session.createQuery(hql).setParameter("resourceId", (Object)this.project.getId()).setParameter("rootSnapshotId", (Object)projectSnapshot.getId()).setMaxResults(1).getResultList();
        return snapshots.isEmpty() ? null : (Snapshot)snapshots.get(0);
    }

    private void log(PastSnapshot pastSnapshot) {
        String qualifier = pastSnapshot.getQualifier();
        if (StringUtils.equals((String)"VW", (String)qualifier) || StringUtils.equals((String)"SVW", (String)qualifier)) {
            LOG.debug(pastSnapshot.toString());
        } else {
            LOG.info(pastSnapshot.toString());
        }
    }

    public List<Period> periods() {
        return this.periods;
    }

    public List<PastSnapshot> getProjectPastSnapshots() {
        return this.modulePastSnapshots;
    }
}

