/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Library;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.security.ResourcePermissions;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.index.ResourceCache;
import org.sonar.batch.index.ResourceCopy;
import org.sonar.batch.index.ResourceNotPersistedException;
import org.sonar.batch.index.ResourcePersister;
import org.sonar.batch.index.SnapshotCache;

public final class DefaultResourcePersister
implements ResourcePersister {
    private static final String RESOURCE_ID = "resourceId";
    private static final String LAST = "last";
    private static final String VERSION = "version";
    private static final String SCOPE = "scope";
    private static final String QUALIFIER = "qualifier";
    private final DatabaseSession session;
    private final Map<Resource, Snapshot> snapshotsByResource = Maps.newHashMap();
    private final ResourcePermissions permissions;
    private final SnapshotCache snapshotCache;
    private final ResourceCache resourceCache;

    public DefaultResourcePersister(DatabaseSession session, ResourcePermissions permissions, SnapshotCache snapshotCache, ResourceCache resourceCache) {
        this.session = session;
        this.permissions = permissions;
        this.snapshotCache = snapshotCache;
        this.resourceCache = resourceCache;
    }

    @Override
    public Snapshot saveProject(Project project, Project parent) {
        Snapshot snapshot = this.snapshotsByResource.get(project);
        if (snapshot == null) {
            snapshot = this.persistProject(project, parent);
            this.addToCache((Resource)project, snapshot);
        }
        return snapshot;
    }

    private void addToCache(Resource resource, Snapshot snapshot) {
        if (snapshot != null) {
            this.snapshotsByResource.put(resource, snapshot);
            this.resourceCache.add(resource);
            this.snapshotCache.put(resource.getEffectiveKey(), snapshot);
        }
    }

    private Snapshot persistProject(Project project, Project parent) {
        project.setEffectiveKey(project.getKey());
        ResourceModel model = this.findOrCreateModel((Resource)project);
        model.setLanguageKey(project.getLanguageKey());
        if (project instanceof ResourceCopy) {
            model.setCopyResourceId(Integer.valueOf(((ResourceCopy)project).getCopyResourceId()));
        }
        Snapshot parentSnapshot = null;
        if (parent != null) {
            parentSnapshot = this.snapshotsByResource.get(project.getParent());
            model.setRootId((Integer)ObjectUtils.defaultIfNull((Object)parentSnapshot.getRootProjectId(), (Object)parentSnapshot.getResourceId()));
        } else {
            model.setRootId(null);
        }
        model = (ResourceModel)this.session.save((Object)model);
        project.setId(model.getId());
        Snapshot snapshot = new Snapshot(model, parentSnapshot);
        snapshot.setVersion(project.getAnalysisVersion());
        snapshot.setCreatedAt(project.getAnalysisDate());
        snapshot.setBuildDate(new Date());
        snapshot = (Snapshot)this.session.save((Object)snapshot);
        this.session.commit();
        if (!this.permissions.hasRoles((Resource)project)) {
            this.permissions.grantDefaultRoles((Resource)project);
        }
        return snapshot;
    }

    @Override
    public Snapshot getSnapshot(Resource reference) {
        return this.snapshotsByResource.get(reference);
    }

    @Override
    public Snapshot getSnapshotOrFail(Resource resource) {
        Snapshot snapshot = this.getSnapshot(resource);
        if (snapshot == null) {
            throw new ResourceNotPersistedException(resource);
        }
        return snapshot;
    }

    Map<Resource, Snapshot> getSnapshotsByResource() {
        return this.snapshotsByResource;
    }

    @Override
    public Snapshot saveResource(Project project, Resource resource) {
        return this.saveResource(project, resource, null);
    }

    @Override
    public Snapshot saveResource(Project project, Resource resource, Resource parent) {
        Snapshot snapshot = this.snapshotsByResource.get(resource);
        if (snapshot == null) {
            snapshot = this.persist(project, resource, parent);
            this.addToCache(resource, snapshot);
        }
        return snapshot;
    }

    private Snapshot persist(Project project, Resource resource, Resource parent) {
        Snapshot snapshot = resource instanceof Project ? this.persistProject((Project)resource, project) : (resource instanceof Library ? this.persistLibrary(project, (Library)resource) : this.persistFileOrDirectory(project, resource, parent));
        return snapshot;
    }

    private Snapshot persistLibrary(Project project, Library library) {
        ResourceModel model = this.findOrCreateModel((Resource)library);
        model = (ResourceModel)this.session.save((Object)model);
        library.setId(model.getId());
        library.setEffectiveKey(library.getKey());
        Snapshot snapshot = this.findLibrarySnapshot(model.getId(), library.getVersion());
        if (snapshot == null) {
            snapshot = new Snapshot(model, null);
            snapshot.setCreatedAt(project.getAnalysisDate());
            snapshot.setBuildDate(new Date());
            snapshot.setVersion(library.getVersion());
            snapshot.setStatus("P");
            snapshot.setQualifier("LIB");
            snapshot = (Snapshot)this.session.save((Object)snapshot);
        }
        this.session.commit();
        return snapshot;
    }

    private Snapshot findLibrarySnapshot(Integer resourceId, String version) {
        Query query = this.session.createQuery("from " + Snapshot.class.getSimpleName() + " s WHERE s.resourceId=:resourceId AND s.version=:version AND s.scope=:scope AND s.qualifier<>:qualifier AND s.last=:last");
        query.setParameter(RESOURCE_ID, (Object)resourceId);
        query.setParameter(VERSION, (Object)version);
        query.setParameter(SCOPE, (Object)"PRJ");
        query.setParameter(QUALIFIER, (Object)"LIB");
        query.setParameter(LAST, (Object)Boolean.TRUE);
        List snapshots = query.getResultList();
        if (snapshots.isEmpty()) {
            snapshots = this.session.getResults(Snapshot.class, new Object[]{RESOURCE_ID, resourceId, VERSION, version, SCOPE, "PRJ", QUALIFIER, "LIB"});
        }
        return snapshots.isEmpty() ? null : (Snapshot)snapshots.get(0);
    }

    private Snapshot persistFileOrDirectory(Project project, Resource resource, Resource parentReference) {
        ResourceModel model = this.findOrCreateModel(resource);
        Snapshot projectSnapshot = this.snapshotsByResource.get(project);
        model.setRootId(projectSnapshot.getResourceId());
        model = (ResourceModel)this.session.save((Object)model);
        resource.setId(model.getId());
        Snapshot parentSnapshot = (Snapshot)ObjectUtils.defaultIfNull((Object)this.getSnapshot(parentReference), (Object)projectSnapshot);
        Snapshot snapshot = new Snapshot(model, parentSnapshot);
        snapshot.setBuildDate(new Date());
        snapshot = (Snapshot)this.session.save((Object)snapshot);
        this.session.commit();
        return snapshot;
    }

    @Override
    public Snapshot getLastSnapshot(Snapshot snapshot, boolean onlyOlder) {
        String hql = "SELECT s FROM " + Snapshot.class.getSimpleName() + " s WHERE s.last=:last AND s.resourceId=:resourceId";
        if (onlyOlder) {
            hql = hql + " AND s.createdAt<:date";
        }
        Query query = this.session.createQuery(hql);
        query.setParameter(LAST, (Object)true);
        query.setParameter(RESOURCE_ID, (Object)snapshot.getResourceId());
        if (onlyOlder) {
            query.setParameter("date", (Object)snapshot.getCreatedAt());
        }
        return (Snapshot)this.session.getSingleResult(query, null);
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<Resource, Snapshot>> it = this.snapshotsByResource.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Resource, Snapshot> entry = it.next();
            if (ResourceUtils.isSet((Resource)entry.getKey())) continue;
            it.remove();
        }
    }

    private ResourceModel findOrCreateModel(Resource resource) {
        try {
            ResourceModel model = (ResourceModel)this.session.getSingleResult(ResourceModel.class, new Object[]{"key", resource.getEffectiveKey()});
            if (model == null) {
                model = DefaultResourcePersister.createModel(resource);
            } else {
                DefaultResourcePersister.mergeModel(model, resource);
            }
            return model;
        }
        catch (NonUniqueResultException e) {
            throw new SonarException("The resource '" + resource.getEffectiveKey() + "' is duplicated in database.", (Throwable)e);
        }
    }

    static ResourceModel createModel(Resource resource) {
        ResourceModel model = new ResourceModel();
        model.setEnabled(Boolean.TRUE);
        model.setDescription(resource.getDescription());
        model.setKey(resource.getEffectiveKey());
        if (resource.getLanguage() != null) {
            model.setLanguageKey(resource.getLanguage().getKey());
        }
        if (StringUtils.isNotBlank((String)resource.getName())) {
            model.setName(resource.getName());
        } else {
            model.setName(resource.getKey());
        }
        model.setLongName(resource.getLongName());
        model.setScope(resource.getScope());
        model.setQualifier(resource.getQualifier());
        return model;
    }

    static void mergeModel(ResourceModel model, Resource resource) {
        model.setEnabled(Boolean.valueOf(true));
        if (StringUtils.isNotBlank((String)resource.getName())) {
            model.setName(resource.getName());
        }
        if (StringUtils.isNotBlank((String)resource.getLongName())) {
            model.setLongName(resource.getLongName());
        }
        if (StringUtils.isNotBlank((String)resource.getDescription())) {
            model.setDescription(resource.getDescription());
        }
        if (!ResourceUtils.isLibrary((Resource)resource)) {
            if ("PRJ".equals(resource.getScope()) && "BRC".equals(resource.getQualifier()) && "TRK".equals(model.getQualifier())) {
                throw new SonarException(String.format("The project '%s' is already defined in SonarQube but not as a module of project '%s'. If you really want to stop directly analysing project '%s', please first delete it from SonarQube and then relaunch the analysis of project '%s'.", resource.getKey(), resource.getParent().getKey(), resource.getKey(), resource.getParent().getKey()));
            }
            model.setScope(resource.getScope());
            model.setQualifier(resource.getQualifier());
        }
        if (resource.getLanguage() != null) {
            model.setLanguageKey(resource.getLanguage().getKey());
        }
    }
}

