/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.events.DecoratorExecutionHandler;
import org.sonar.api.batch.events.DecoratorsPhaseHandler;
import org.sonar.api.batch.events.SensorExecutionHandler;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.MeasureData;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PersistenceMode;

public class MemoryOptimizer
implements SensorExecutionHandler,
DecoratorExecutionHandler,
DecoratorsPhaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryOptimizer.class);
    private List<Measure> loadedMeasures = Lists.newArrayList();
    private Map<Long, Integer> dataIdByMeasureId = Maps.newHashMap();
    private DatabaseSession session;

    public MemoryOptimizer(DatabaseSession session) {
        this.session = session;
    }

    public void evictDataMeasure(Measure measure, MeasureModel model) {
        MeasureData data;
        if (PersistenceMode.DATABASE.equals((Object)measure.getPersistenceMode()) && (data = model.getMeasureData()) != null && data.getId() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remove data measure from memory: " + measure.getMetricKey() + ", id=" + measure.getId());
            }
            measure.unsetData();
            this.dataIdByMeasureId.put(measure.getId(), data.getId());
        }
    }

    public Measure reloadMeasure(Measure measure) {
        if (measure.getId() != null && this.dataIdByMeasureId.containsKey(measure.getId()) && !measure.hasData()) {
            Integer dataId = this.dataIdByMeasureId.get(measure.getId());
            MeasureData data = (MeasureData)this.session.getSingleResult(MeasureData.class, new Object[]{"id", dataId});
            if (data == null) {
                LOG.error("The MEASURE_DATA row with id {} is lost", (Object)dataId);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reload the data measure: {}, id={}", (Object)measure.getMetricKey(), (Object)measure.getId());
                }
                measure.setData(data.getText());
                this.loadedMeasures.add(measure);
            }
        }
        return measure;
    }

    public void flushMemory() {
        if (LOG.isDebugEnabled() && !this.loadedMeasures.isEmpty()) {
            LOG.debug("Flush {} data measures from memory: ", (Object)this.loadedMeasures.size());
        }
        for (Measure measure : this.loadedMeasures) {
            measure.unsetData();
        }
        this.loadedMeasures.clear();
    }

    boolean isTracked(Long measureId) {
        return this.dataIdByMeasureId.get(measureId) != null;
    }

    public void onSensorExecution(SensorExecutionHandler.SensorExecutionEvent event) {
        if (event.isEnd()) {
            this.flushMemory();
            this.session.commit();
        }
    }

    public void onDecoratorExecution(DecoratorExecutionHandler.DecoratorExecutionEvent event) {
        if (event.isEnd()) {
            this.flushMemory();
        }
    }

    public void onDecoratorsPhase(DecoratorsPhaseHandler.DecoratorsPhaseEvent event) {
        if (event.isEnd()) {
            this.session.commit();
        }
    }
}

