/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.index.ScanPersister;
import org.sonar.batch.issue.IssueCache;
import org.sonar.batch.issue.ScanIssueStorage;

public class IssuePersister
implements ScanPersister {
    private static final Logger LOG = LoggerFactory.getLogger(IssuePersister.class);
    private final IssueCache issueCache;
    private final ScanIssueStorage storage;
    private AnalysisMode analysisMode;

    public IssuePersister(IssueCache issueCache, ScanIssueStorage storage, AnalysisMode analysisMode) {
        this.issueCache = issueCache;
        this.storage = storage;
        this.analysisMode = analysisMode;
    }

    @Override
    public void persist() {
        if (this.analysisMode.isPreview()) {
            LOG.debug("IssuePersister skipped in preview mode");
            return;
        }
        Iterable<DefaultIssue> issues = this.issueCache.all();
        this.storage.save(issues);
    }
}

