/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import org.sonar.api.BatchComponent;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.rules.RuleFinder;
import org.sonar.batch.index.SnapshotCache;
import org.sonar.core.issue.db.IssueStorage;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.resource.ResourceDao;
import org.sonar.core.resource.ResourceDto;
import org.sonar.core.resource.ResourceQuery;

public class ScanIssueStorage
extends IssueStorage
implements BatchComponent {
    private final SnapshotCache snapshotCache;
    private final ResourceDao resourceDao;

    public ScanIssueStorage(MyBatis mybatis, RuleFinder ruleFinder, SnapshotCache snapshotCache, ResourceDao resourceDao) {
        super(mybatis, ruleFinder);
        this.snapshotCache = snapshotCache;
        this.resourceDao = resourceDao;
    }

    protected long componentId(DefaultIssue issue) {
        Snapshot snapshot = this.getSnapshot(issue);
        if (snapshot != null) {
            return snapshot.getResourceId().intValue();
        }
        ResourceDto resourceDto = this.resourceDao.getResource(ResourceQuery.create().setKey(issue.componentKey()));
        if (resourceDto == null) {
            throw new IllegalStateException("Unknown component: " + issue.componentKey());
        }
        return resourceDto.getId();
    }

    protected long projectId(DefaultIssue issue) {
        Snapshot snapshot = this.getSnapshot(issue);
        if (snapshot != null) {
            return snapshot.getRootProjectId().intValue();
        }
        throw new IllegalStateException("Project id not found for: " + issue.componentKey());
    }

    private Snapshot getSnapshot(DefaultIssue issue) {
        Snapshot snapshot = this.snapshotCache.get(issue.componentKey());
        if (snapshot != null) {
            return snapshot;
        }
        return null;
    }
}

